// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_EXTENDABLE_MESSAGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_EXTENDABLE_MESSAGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MessagePort;
class ServiceWorker;
class ServiceWorkerClient;
class V8UnionClientOrMessagePortOrServiceWorker;

class MODULES_EXPORT ExtendableMessageEventInit : public ExtendableEventInit {
  
  public:
static ExtendableMessageEventInit* Create() {
  return MakeGarbageCollected<ExtendableMessageEventInit>();
}
static ExtendableMessageEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ExtendableMessageEventInit>(isolate);
}
static ExtendableMessageEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ExtendableMessageEventInit();
explicit  ExtendableMessageEventInit(v8::Isolate* isolate);

bool hasData() const {
  return !member_data_.IsEmpty();
}
const ScriptValue& data() const {
  DCHECK(hasData());
return member_data_;
}
ScriptValue getDataOr(const ScriptValue& fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_;
}
void setData(const ScriptValue& value) {
  member_data_ = value;
}

bool hasLastEventId() const {
  return has_last_event_id_;
}
const String& lastEventId() const {
  DCHECK(hasLastEventId());
return member_last_event_id_;
}
String getLastEventIdOr(const String& fallback_value) const;
String getLastEventIdOr(String&& fallback_value) const;
void setLastEventId(const String& value);
void setLastEventId(String&& value);

bool hasOrigin() const {
  return has_origin_;
}
const String& origin() const {
  DCHECK(hasOrigin());
return member_origin_;
}
String getOriginOr(const String& fallback_value) const;
String getOriginOr(String&& fallback_value) const;
void setOrigin(const String& value);
void setOrigin(String&& value);

bool hasPorts() const {
  return has_ports_;
}
const HeapVector<Member<MessagePort>>& ports() const {
  DCHECK(hasPorts());
return member_ports_;
}
HeapVector<Member<MessagePort>> getPortsOr(const HeapVector<Member<MessagePort>>& fallback_value) const;
HeapVector<Member<MessagePort>> getPortsOr(HeapVector<Member<MessagePort>>&& fallback_value) const;
void setPorts(const HeapVector<Member<MessagePort>>& value);
void setPorts(HeapVector<Member<MessagePort>>&& value);

bool hasSource() const {
  return has_source_;
}
V8UnionClientOrMessagePortOrServiceWorker* source() const {
  DCHECK(hasSource());
return member_source_.Get();
}
V8UnionClientOrMessagePortOrServiceWorker* getSourceOr(V8UnionClientOrMessagePortOrServiceWorker* fallback_value) const {
  if (!hasSource()) {
  return fallback_value;
}
return member_source_.Get();
}
void setSource(V8UnionClientOrMessagePortOrServiceWorker* value) {
  member_source_ = value;
has_source_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_last_event_id_ = false;
bool has_origin_ = false;
bool has_ports_ = false;
bool has_source_ = false;

ScriptValue member_data_;
String member_last_event_id_;
String member_origin_;
HeapVector<Member<MessagePort>> member_ports_;
Member<V8UnionClientOrMessagePortOrServiceWorker> member_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_EXTENDABLE_MESSAGE_EVENT_INIT_H_
