// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DYNAMICS_COMPRESSOR_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DYNAMICS_COMPRESSOR_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT DynamicsCompressorOptions : public AudioNodeOptions {
  
  public:
static DynamicsCompressorOptions* Create() {
  return MakeGarbageCollected<DynamicsCompressorOptions>();
}
static DynamicsCompressorOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DynamicsCompressorOptions>(isolate);
}
static DynamicsCompressorOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DynamicsCompressorOptions();
explicit  DynamicsCompressorOptions(v8::Isolate* isolate);

bool hasAttack() const {
  return true;
}
float attack() const {
  return member_attack_;
}
void setAttack(float value) {
  member_attack_ = value;
}

bool hasKnee() const {
  return true;
}
float knee() const {
  return member_knee_;
}
void setKnee(float value) {
  member_knee_ = value;
}

bool hasRatio() const {
  return true;
}
float ratio() const {
  return member_ratio_;
}
void setRatio(float value) {
  member_ratio_ = value;
}

bool hasRelease() const {
  return true;
}
float release() const {
  return member_release_;
}
void setRelease(float value) {
  member_release_ = value;
}

bool hasThreshold() const {
  return true;
}
float threshold() const {
  return member_threshold_;
}
void setThreshold(float value) {
  member_threshold_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



float member_attack_{0.003};
float member_knee_{30};
float member_ratio_{12};
float member_release_{0.25};
float member_threshold_{-24};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DYNAMICS_COMPRESSOR_OPTIONS_H_
