// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_ORIENTATION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_ORIENTATION_EVENT_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT DeviceOrientationEventInit : public EventInit {
  
  public:
static DeviceOrientationEventInit* Create() {
  return MakeGarbageCollected<DeviceOrientationEventInit>();
}
static DeviceOrientationEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DeviceOrientationEventInit>(isolate);
}
static DeviceOrientationEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DeviceOrientationEventInit();
explicit  DeviceOrientationEventInit(v8::Isolate* isolate);

bool hasAbsolute() const {
  return true;
}
bool absolute() const {
  return member_absolute_;
}
void setAbsolute(bool value) {
  member_absolute_ = value;
}

bool hasAlpha() const {
  return true;
}
const std::optional<double>& alpha() const {
  return member_alpha_;
}
void setAlpha(const std::optional<double>& value) {
  member_alpha_ = value;
}
void setAlpha(double value) {
  member_alpha_ = value;
}

bool hasBeta() const {
  return true;
}
const std::optional<double>& beta() const {
  return member_beta_;
}
void setBeta(const std::optional<double>& value) {
  member_beta_ = value;
}
void setBeta(double value) {
  member_beta_ = value;
}

bool hasGamma() const {
  return true;
}
const std::optional<double>& gamma() const {
  return member_gamma_;
}
void setGamma(const std::optional<double>& value) {
  member_gamma_ = value;
}
void setGamma(double value) {
  member_gamma_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_absolute_{false};
std::optional<double> member_alpha_;
std::optional<double> member_beta_;
std::optional<double> member_gamma_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_ORIENTATION_EVENT_INIT_H_
