// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_MOTION_EVENT_ROTATION_RATE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_MOTION_EVENT_ROTATION_RATE_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT DeviceMotionEventRotationRateInit : public bindings::InputDictionaryBase {
  
  public:
static DeviceMotionEventRotationRateInit* Create() {
  return MakeGarbageCollected<DeviceMotionEventRotationRateInit>();
}
static DeviceMotionEventRotationRateInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DeviceMotionEventRotationRateInit>(isolate);
}
static DeviceMotionEventRotationRateInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DeviceMotionEventRotationRateInit();
explicit  DeviceMotionEventRotationRateInit(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
const std::optional<double>& alpha() const {
  return member_alpha_;
}
void setAlpha(const std::optional<double>& value) {
  member_alpha_ = value;
}
void setAlpha(double value) {
  member_alpha_ = value;
}

bool hasBeta() const {
  return true;
}
const std::optional<double>& beta() const {
  return member_beta_;
}
void setBeta(const std::optional<double>& value) {
  member_beta_ = value;
}
void setBeta(double value) {
  member_beta_ = value;
}

bool hasGamma() const {
  return true;
}
const std::optional<double>& gamma() const {
  return member_gamma_;
}
void setGamma(const std::optional<double>& value) {
  member_gamma_ = value;
}
void setGamma(double value) {
  member_gamma_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



std::optional<double> member_alpha_;
std::optional<double> member_beta_;
std::optional<double> member_gamma_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DEVICE_MOTION_EVENT_ROTATION_RATE_INIT_H_
