// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COOKIE_LIST_ITEM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COOKIE_LIST_ITEM_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_same_site.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CookieListItem : public bindings::DictionaryBase {
  
  public:
static CookieListItem* Create() {
  return MakeGarbageCollected<CookieListItem>();
}
static CookieListItem* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CookieListItem>(isolate);
}
static CookieListItem* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CookieListItem();
explicit  CookieListItem(v8::Isolate* isolate);

bool hasDomain() const {
  return has_domain_;
}
const String& domain() const {
  DCHECK(hasDomain());
return member_domain_;
}
String getDomainOr(const String& fallback_value) const;
String getDomainOr(String&& fallback_value) const;
void setDomain(const String& value);
void setDomain(String&& value);

bool hasExpires() const {
  return has_expires_;
}
const std::optional<double>& expires() const {
  DCHECK(hasExpires());
return member_expires_;
}
std::optional<double> getExpiresOr(const std::optional<double>& fallback_value) const {
  if (!hasExpires()) {
  return fallback_value;
}
return member_expires_;
}
void setExpires(const std::optional<double>& value) {
  member_expires_ = value;
has_expires_ = true;
}
void setExpires(double value) {
  member_expires_ = value;
has_expires_ = true;
}

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasPartitioned() const {
  return has_partitioned_;
}
bool partitioned() const {
  DCHECK(hasPartitioned());
return member_partitioned_;
}
bool getPartitionedOr(bool fallback_value) const {
  if (!hasPartitioned()) {
  return fallback_value;
}
return member_partitioned_;
}
void setPartitioned(bool value) {
  member_partitioned_ = value;
has_partitioned_ = true;
}

bool hasPath() const {
  return has_path_;
}
const String& path() const {
  DCHECK(hasPath());
return member_path_;
}
String getPathOr(const String& fallback_value) const;
String getPathOr(String&& fallback_value) const;
void setPath(const String& value);
void setPath(String&& value);

bool hasSameSite() const {
  return has_same_site_;
}
V8CookieSameSite sameSite() const {
  DCHECK(hasSameSite());
return member_same_site_;
}
V8CookieSameSite getSameSiteOr(V8CookieSameSite fallback_value) const {
  if (!hasSameSite()) {
  return fallback_value;
}
return member_same_site_;
}
void setSameSite(V8CookieSameSite value) {
  member_same_site_ = value;
has_same_site_ = true;
}
void setSameSite(V8CookieSameSite::Enum value) {
  member_same_site_ = V8CookieSameSite(value);
has_same_site_ = true;
}

bool hasSecure() const {
  return has_secure_;
}
bool secure() const {
  DCHECK(hasSecure());
return member_secure_;
}
bool getSecureOr(bool fallback_value) const {
  if (!hasSecure()) {
  return fallback_value;
}
return member_secure_;
}
void setSecure(bool value) {
  member_secure_ = value;
has_secure_ = true;
}

bool hasValue() const {
  return has_value_;
}
const String& value() const {
  DCHECK(hasValue());
return member_value_;
}
String getValueOr(const String& fallback_value) const;
String getValueOr(String&& fallback_value) const;
void setValue(const String& value);
void setValue(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_domain_ = false;
bool has_expires_ = false;
bool has_name_ = false;
bool has_partitioned_ = false;
bool has_path_ = false;
bool has_same_site_ = false;
bool has_secure_ = false;
bool has_value_ = false;

String member_domain_;
std::optional<double> member_expires_;
String member_name_;
bool member_partitioned_;
String member_path_;
V8CookieSameSite member_same_site_{static_cast<V8CookieSameSite::Enum>(0)};
bool member_secure_;
String member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COOKIE_LIST_ITEM_H_
