// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COOKIE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COOKIE_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_same_site.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CookieInit : public bindings::InputDictionaryBase {
  
  public:
static CookieInit* Create() {
  return MakeGarbageCollected<CookieInit>();
}
static CookieInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CookieInit>(isolate);
}
static CookieInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CookieInit();
explicit  CookieInit(v8::Isolate* isolate);

bool hasDomain() const {
  return true;
}
const String& domain() const {
  return member_domain_;
}
void setDomain(const String& value);
void setDomain(String&& value);

bool hasExpires() const {
  return true;
}
const std::optional<double>& expires() const {
  return member_expires_;
}
void setExpires(const std::optional<double>& value) {
  member_expires_ = value;
}
void setExpires(double value) {
  member_expires_ = value;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);

bool hasPartitioned() const {
  return true;
}
bool partitioned() const {
  return member_partitioned_;
}
void setPartitioned(bool value) {
  member_partitioned_ = value;
}

bool hasPath() const {
  return true;
}
const String& path() const {
  return member_path_;
}
void setPath(const String& value);
void setPath(String&& value);

bool hasSameSite() const {
  return true;
}
V8CookieSameSite sameSite() const {
  return member_same_site_;
}
void setSameSite(V8CookieSameSite value) {
  member_same_site_ = value;
}
void setSameSite(V8CookieSameSite::Enum value) {
  member_same_site_ = V8CookieSameSite(value);
}

bool hasValue() const {
  return true;
}
const String& value() const {
  return member_value_;
}
void setValue(const String& value);
void setValue(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_domain_;
std::optional<double> member_expires_;
String member_name_;
bool member_partitioned_{false};
String member_path_{"/"};
V8CookieSameSite member_same_site_{V8CookieSameSite::Enum::kStrict};
String member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COOKIE_INIT_H_
