// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_change_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_list_item.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"changed",
"deleted",
};


}  // namespace 

CookieChangeEventInit* CookieChangeEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CookieChangeEventInit* dictionary = MakeGarbageCollected<CookieChangeEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CookieChangeEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CookieChangeEventInit::CookieChangeEventInit() {
  
}

 CookieChangeEventInit::CookieChangeEventInit(v8::Isolate* isolate) : EventInit(isolate) {
  
}



HeapVector<Member<CookieListItem>> CookieChangeEventInit::getChangedOr(const HeapVector<Member<CookieListItem>>& fallback_value) const {
  if (!hasChanged()) {
  return fallback_value;
}
return member_changed_;
}

HeapVector<Member<CookieListItem>> CookieChangeEventInit::getChangedOr(HeapVector<Member<CookieListItem>>&& fallback_value) const {
  if (!hasChanged()) {
  return std::move(fallback_value);
}
return member_changed_;
}

void CookieChangeEventInit::setChanged(const HeapVector<Member<CookieListItem>>& value) {
  member_changed_ = value;
has_changed_ = true;
}

void CookieChangeEventInit::setChanged(HeapVector<Member<CookieListItem>>&& value) {
  member_changed_ = std::move(value);
has_changed_ = true;
}




HeapVector<Member<CookieListItem>> CookieChangeEventInit::getDeletedOr(const HeapVector<Member<CookieListItem>>& fallback_value) const {
  if (!hasDeleted()) {
  return fallback_value;
}
return member_deleted_;
}

HeapVector<Member<CookieListItem>> CookieChangeEventInit::getDeletedOr(HeapVector<Member<CookieListItem>>&& fallback_value) const {
  if (!hasDeleted()) {
  return std::move(fallback_value);
}
return member_deleted_;
}

void CookieChangeEventInit::setDeleted(const HeapVector<Member<CookieListItem>>& value) {
  member_deleted_ = value;
has_deleted_ = true;
}

void CookieChangeEventInit::setDeleted(HeapVector<Member<CookieListItem>>&& value) {
  member_deleted_ = std::move(value);
has_deleted_ = true;
}



void CookieChangeEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_changed_);
visitor->Trace(member_deleted_);
EventInit::Trace(visitor);
}

void CookieChangeEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "CookieChangeEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("changed");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<CookieListItem>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_changed_, member_changed_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("deleted");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<CookieListItem>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_deleted_, member_deleted_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CookieChangeEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
