// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_content_description.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_content_icon_definition.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"category",
"description",
"icons",
"id",
"title",
"url",
};


}  // namespace 

ContentDescription* ContentDescription::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ContentDescription* dictionary = MakeGarbageCollected<ContentDescription>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ContentDescription";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ContentDescription::ContentDescription() {
  
}

 ContentDescription::ContentDescription(v8::Isolate* isolate) {
  
}








void ContentDescription::setDescription(const String& value) {
  member_description_ = value;
}

void ContentDescription::setDescription(String&& value) {
  member_description_ = std::move(value);
}




void ContentDescription::setIcons(const HeapVector<Member<ContentIconDefinition>>& value) {
  member_icons_ = value;
}

void ContentDescription::setIcons(HeapVector<Member<ContentIconDefinition>>&& value) {
  member_icons_ = std::move(value);
}




void ContentDescription::setId(const String& value) {
  member_id_ = value;
}

void ContentDescription::setId(String&& value) {
  member_id_ = std::move(value);
}




void ContentDescription::setTitle(const String& value) {
  member_title_ = value;
}

void ContentDescription::setTitle(String&& value) {
  member_title_ = std::move(value);
}




void ContentDescription::setUrl(const String& value) {
  member_url_ = value;
}

void ContentDescription::setUrl(String&& value) {
  member_url_ = std::move(value);
}



void ContentDescription::Trace(Visitor* visitor) const {
  visitor->Trace(member_icons_);
bindings::DictionaryBase::Trace(visitor);
}

void ContentDescription::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ContentDescription::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCategory()) {
  values[0] = ToV8Traits<V8ContentCategory>::ToV8(script_state, member_category_);
DCHECK(!values[0].IsEmpty());
}
if (hasDescription()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_description_);
DCHECK(!values[1].IsEmpty());
}
if (hasIcons()) {
  values[2] = ToV8Traits<IDLSequence<ContentIconDefinition>>::ToV8(script_state, member_icons_);
DCHECK(!values[2].IsEmpty());
}
if (hasId()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_id_);
DCHECK(!values[3].IsEmpty());
}
if (hasTitle()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_title_);
DCHECK(!values[4].IsEmpty());
}
if (hasUrl()) {
  values[5] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_url_);
DCHECK(!values[5].IsEmpty());
}
}

const void* ContentDescription::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ContentDescription::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ContentDescription::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ContentDescription";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("category");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8ContentCategory, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_category_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("description");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_description_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("icons");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<ContentIconDefinition>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_icons_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("id");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("title");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_title_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("url");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_url_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ContentDescription::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
