// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLOSE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLOSE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CloseEventInit : public EventInit {
  
  public:
static CloseEventInit* Create() {
  return MakeGarbageCollected<CloseEventInit>();
}
static CloseEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CloseEventInit>(isolate);
}
static CloseEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CloseEventInit();
explicit  CloseEventInit(v8::Isolate* isolate);

bool hasCode() const {
  return has_code_;
}
uint16_t code() const {
  DCHECK(hasCode());
return member_code_;
}
uint16_t getCodeOr(uint16_t fallback_value) const {
  if (!hasCode()) {
  return fallback_value;
}
return member_code_;
}
void setCode(uint16_t value) {
  member_code_ = value;
has_code_ = true;
}

bool hasReason() const {
  return has_reason_;
}
const String& reason() const {
  DCHECK(hasReason());
return member_reason_;
}
String getReasonOr(const String& fallback_value) const;
String getReasonOr(String&& fallback_value) const;
void setReason(const String& value);
void setReason(String&& value);

bool hasWasClean() const {
  return has_was_clean_;
}
bool wasClean() const {
  DCHECK(hasWasClean());
return member_was_clean_;
}
bool getWasCleanOr(bool fallback_value) const {
  if (!hasWasClean()) {
  return fallback_value;
}
return member_was_clean_;
}
void setWasClean(bool value) {
  member_was_clean_ = value;
has_was_clean_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_code_ = false;
bool has_reason_ = false;
bool has_was_clean_ = false;

uint16_t member_code_;
String member_reason_;
bool member_was_clean_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLOSE_EVENT_INIT_H_
