// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_clipboard_read_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"types",
"unsanitized",
};


}  // namespace 

ClipboardReadOptions* ClipboardReadOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ClipboardReadOptions* dictionary = MakeGarbageCollected<ClipboardReadOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ClipboardReadOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ClipboardReadOptions::ClipboardReadOptions() {
  
}

 ClipboardReadOptions::ClipboardReadOptions(v8::Isolate* isolate) {
  
}



std::optional<Vector<String>> ClipboardReadOptions::getTypesOr(const std::optional<Vector<String>>& fallback_value) const {
  if (!hasTypes()) {
  return fallback_value;
}
return member_types_;
}

std::optional<Vector<String>> ClipboardReadOptions::getTypesOr(std::optional<Vector<String>>&& fallback_value) const {
  if (!hasTypes()) {
  return std::move(fallback_value);
}
return member_types_;
}

void ClipboardReadOptions::setTypes(const std::optional<Vector<String>>& value) {
  member_types_ = value;
has_types_ = true;
}

void ClipboardReadOptions::setTypes(std::optional<Vector<String>>&& value) {
  member_types_ = std::move(value);
has_types_ = true;
}

void ClipboardReadOptions::setTypes(const Vector<String>& value) {
  member_types_ = value;
has_types_ = true;
}

void ClipboardReadOptions::setTypes(Vector<String>&& value) {
  member_types_ = std::move(value);
has_types_ = true;
}



Vector<String> ClipboardReadOptions::getUnsanitizedOr(const Vector<String>& fallback_value) const {
  if (!hasUnsanitized()) {
  return fallback_value;
}
return member_unsanitized_;
}

Vector<String> ClipboardReadOptions::getUnsanitizedOr(Vector<String>&& fallback_value) const {
  if (!hasUnsanitized()) {
  return std::move(fallback_value);
}
return member_unsanitized_;
}

void ClipboardReadOptions::setUnsanitized(const Vector<String>& value) {
  member_unsanitized_ = value;
has_unsanitized_ = true;
}

void ClipboardReadOptions::setUnsanitized(Vector<String>&& value) {
  member_unsanitized_ = std::move(value);
has_unsanitized_ = true;
}



void ClipboardReadOptions::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void ClipboardReadOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ClipboardReadOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::SelectiveClipboardFormatReadEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("types");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLSequence<IDLString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_types_, member_types_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("unsanitized");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_unsanitized_, member_unsanitized_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ClipboardReadOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
