// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_can_make_payment_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_modifier.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_method_data.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"methodData",
"modifiers",
"paymentRequestOrigin",
"topOrigin",
};


}  // namespace 

CanMakePaymentEventInit* CanMakePaymentEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CanMakePaymentEventInit* dictionary = MakeGarbageCollected<CanMakePaymentEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CanMakePaymentEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CanMakePaymentEventInit::CanMakePaymentEventInit() {
  
}

 CanMakePaymentEventInit::CanMakePaymentEventInit(v8::Isolate* isolate) : ExtendableEventInit(isolate) {
  
}



HeapVector<Member<PaymentMethodData>> CanMakePaymentEventInit::getMethodDataOr(const HeapVector<Member<PaymentMethodData>>& fallback_value) const {
  if (!hasMethodData()) {
  return fallback_value;
}
return member_method_data_;
}

HeapVector<Member<PaymentMethodData>> CanMakePaymentEventInit::getMethodDataOr(HeapVector<Member<PaymentMethodData>>&& fallback_value) const {
  if (!hasMethodData()) {
  return std::move(fallback_value);
}
return member_method_data_;
}

void CanMakePaymentEventInit::setMethodData(const HeapVector<Member<PaymentMethodData>>& value) {
  member_method_data_ = value;
has_method_data_ = true;
}

void CanMakePaymentEventInit::setMethodData(HeapVector<Member<PaymentMethodData>>&& value) {
  member_method_data_ = std::move(value);
has_method_data_ = true;
}




HeapVector<Member<PaymentDetailsModifier>> CanMakePaymentEventInit::getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const {
  if (!hasModifiers()) {
  return fallback_value;
}
return member_modifiers_;
}

HeapVector<Member<PaymentDetailsModifier>> CanMakePaymentEventInit::getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const {
  if (!hasModifiers()) {
  return std::move(fallback_value);
}
return member_modifiers_;
}

void CanMakePaymentEventInit::setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value) {
  member_modifiers_ = value;
has_modifiers_ = true;
}

void CanMakePaymentEventInit::setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value) {
  member_modifiers_ = std::move(value);
has_modifiers_ = true;
}




String CanMakePaymentEventInit::getPaymentRequestOriginOr(const String& fallback_value) const {
  if (!hasPaymentRequestOrigin()) {
  return fallback_value;
}
return member_payment_request_origin_;
}

String CanMakePaymentEventInit::getPaymentRequestOriginOr(String&& fallback_value) const {
  if (!hasPaymentRequestOrigin()) {
  return std::move(fallback_value);
}
return member_payment_request_origin_;
}

void CanMakePaymentEventInit::setPaymentRequestOrigin(const String& value) {
  member_payment_request_origin_ = value;
has_payment_request_origin_ = true;
}

void CanMakePaymentEventInit::setPaymentRequestOrigin(String&& value) {
  member_payment_request_origin_ = std::move(value);
has_payment_request_origin_ = true;
}




String CanMakePaymentEventInit::getTopOriginOr(const String& fallback_value) const {
  if (!hasTopOrigin()) {
  return fallback_value;
}
return member_top_origin_;
}

String CanMakePaymentEventInit::getTopOriginOr(String&& fallback_value) const {
  if (!hasTopOrigin()) {
  return std::move(fallback_value);
}
return member_top_origin_;
}

void CanMakePaymentEventInit::setTopOrigin(const String& value) {
  member_top_origin_ = value;
has_top_origin_ = true;
}

void CanMakePaymentEventInit::setTopOrigin(String&& value) {
  member_top_origin_ = std::move(value);
has_top_origin_ = true;
}



void CanMakePaymentEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_method_data_);
visitor->Trace(member_modifiers_);
ExtendableEventInit::Trace(visitor);
}

void CanMakePaymentEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
ExtendableEventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "CanMakePaymentEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("methodData");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentMethodData>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_method_data_, member_method_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifiers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentDetailsModifier>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_modifiers_, member_modifiers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("paymentRequestOrigin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_payment_request_origin_, member_payment_request_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("topOrigin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_top_origin_, member_top_origin_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CanMakePaymentEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
