// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_browsing_topic.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"configVersion",
"modelVersion",
"taxonomyVersion",
"topic",
"version",
};


}  // namespace 

BrowsingTopic* BrowsingTopic::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  BrowsingTopic* dictionary = MakeGarbageCollected<BrowsingTopic>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "BrowsingTopic";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 BrowsingTopic::BrowsingTopic() {
  
}

 BrowsingTopic::BrowsingTopic(v8::Isolate* isolate) {
  
}



String BrowsingTopic::getConfigVersionOr(const String& fallback_value) const {
  if (!hasConfigVersion()) {
  return fallback_value;
}
return member_config_version_;
}

String BrowsingTopic::getConfigVersionOr(String&& fallback_value) const {
  if (!hasConfigVersion()) {
  return std::move(fallback_value);
}
return member_config_version_;
}

void BrowsingTopic::setConfigVersion(const String& value) {
  member_config_version_ = value;
has_config_version_ = true;
}

void BrowsingTopic::setConfigVersion(String&& value) {
  member_config_version_ = std::move(value);
has_config_version_ = true;
}




String BrowsingTopic::getModelVersionOr(const String& fallback_value) const {
  if (!hasModelVersion()) {
  return fallback_value;
}
return member_model_version_;
}

String BrowsingTopic::getModelVersionOr(String&& fallback_value) const {
  if (!hasModelVersion()) {
  return std::move(fallback_value);
}
return member_model_version_;
}

void BrowsingTopic::setModelVersion(const String& value) {
  member_model_version_ = value;
has_model_version_ = true;
}

void BrowsingTopic::setModelVersion(String&& value) {
  member_model_version_ = std::move(value);
has_model_version_ = true;
}




String BrowsingTopic::getTaxonomyVersionOr(const String& fallback_value) const {
  if (!hasTaxonomyVersion()) {
  return fallback_value;
}
return member_taxonomy_version_;
}

String BrowsingTopic::getTaxonomyVersionOr(String&& fallback_value) const {
  if (!hasTaxonomyVersion()) {
  return std::move(fallback_value);
}
return member_taxonomy_version_;
}

void BrowsingTopic::setTaxonomyVersion(const String& value) {
  member_taxonomy_version_ = value;
has_taxonomy_version_ = true;
}

void BrowsingTopic::setTaxonomyVersion(String&& value) {
  member_taxonomy_version_ = std::move(value);
has_taxonomy_version_ = true;
}











String BrowsingTopic::getVersionOr(const String& fallback_value) const {
  if (!hasVersion()) {
  return fallback_value;
}
return member_version_;
}

String BrowsingTopic::getVersionOr(String&& fallback_value) const {
  if (!hasVersion()) {
  return std::move(fallback_value);
}
return member_version_;
}

void BrowsingTopic::setVersion(const String& value) {
  member_version_ = value;
has_version_ = true;
}

void BrowsingTopic::setVersion(String&& value) {
  member_version_ = std::move(value);
has_version_ = true;
}



void BrowsingTopic::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void BrowsingTopic::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void BrowsingTopic::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasConfigVersion()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_config_version_);
DCHECK(!values[0].IsEmpty());
}
if (hasModelVersion()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_model_version_);
DCHECK(!values[1].IsEmpty());
}
if (hasTaxonomyVersion()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_taxonomy_version_);
DCHECK(!values[2].IsEmpty());
}
if (hasTopic()) {
  values[3] = ToV8Traits<IDLLong>::ToV8(script_state, member_topic_);
DCHECK(!values[3].IsEmpty());
}
if (hasVersion()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_version_);
DCHECK(!values[4].IsEmpty());
}
}

const void* BrowsingTopic::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> BrowsingTopic::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void BrowsingTopic::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "BrowsingTopic";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("configVersion");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_config_version_, member_config_version_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modelVersion");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_model_version_, member_model_version_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("taxonomyVersion");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_taxonomy_version_, member_taxonomy_version_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("topic");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_topic_, member_topic_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("version");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_version_, member_version_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> BrowsingTopic::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
