// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_bluetooth_le_scan_filter_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_unsignedlong.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_bluetooth_manufacturer_data_filter_init.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"manufacturerData",
"name",
"namePrefix",
"services",
};


}  // namespace 

BluetoothLEScanFilterInit* BluetoothLEScanFilterInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  BluetoothLEScanFilterInit* dictionary = MakeGarbageCollected<BluetoothLEScanFilterInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "BluetoothLEScanFilterInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 BluetoothLEScanFilterInit::BluetoothLEScanFilterInit() {
  
}

 BluetoothLEScanFilterInit::BluetoothLEScanFilterInit(v8::Isolate* isolate) {
  
}



HeapVector<Member<BluetoothManufacturerDataFilterInit>> BluetoothLEScanFilterInit::getManufacturerDataOr(const HeapVector<Member<BluetoothManufacturerDataFilterInit>>& fallback_value) const {
  if (!hasManufacturerData()) {
  return fallback_value;
}
return member_manufacturer_data_;
}

HeapVector<Member<BluetoothManufacturerDataFilterInit>> BluetoothLEScanFilterInit::getManufacturerDataOr(HeapVector<Member<BluetoothManufacturerDataFilterInit>>&& fallback_value) const {
  if (!hasManufacturerData()) {
  return std::move(fallback_value);
}
return member_manufacturer_data_;
}

void BluetoothLEScanFilterInit::setManufacturerData(const HeapVector<Member<BluetoothManufacturerDataFilterInit>>& value) {
  member_manufacturer_data_ = value;
has_manufacturer_data_ = true;
}

void BluetoothLEScanFilterInit::setManufacturerData(HeapVector<Member<BluetoothManufacturerDataFilterInit>>&& value) {
  member_manufacturer_data_ = std::move(value);
has_manufacturer_data_ = true;
}




String BluetoothLEScanFilterInit::getNameOr(const String& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

String BluetoothLEScanFilterInit::getNameOr(String&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void BluetoothLEScanFilterInit::setName(const String& value) {
  member_name_ = value;
has_name_ = true;
}

void BluetoothLEScanFilterInit::setName(String&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}




String BluetoothLEScanFilterInit::getNamePrefixOr(const String& fallback_value) const {
  if (!hasNamePrefix()) {
  return fallback_value;
}
return member_name_prefix_;
}

String BluetoothLEScanFilterInit::getNamePrefixOr(String&& fallback_value) const {
  if (!hasNamePrefix()) {
  return std::move(fallback_value);
}
return member_name_prefix_;
}

void BluetoothLEScanFilterInit::setNamePrefix(const String& value) {
  member_name_prefix_ = value;
has_name_prefix_ = true;
}

void BluetoothLEScanFilterInit::setNamePrefix(String&& value) {
  member_name_prefix_ = std::move(value);
has_name_prefix_ = true;
}




HeapVector<Member<V8UnionStringOrUnsignedLong>> BluetoothLEScanFilterInit::getServicesOr(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& fallback_value) const {
  if (!hasServices()) {
  return fallback_value;
}
return member_services_;
}

HeapVector<Member<V8UnionStringOrUnsignedLong>> BluetoothLEScanFilterInit::getServicesOr(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& fallback_value) const {
  if (!hasServices()) {
  return std::move(fallback_value);
}
return member_services_;
}

void BluetoothLEScanFilterInit::setServices(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value) {
  member_services_ = value;
has_services_ = true;
}

void BluetoothLEScanFilterInit::setServices(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value) {
  member_services_ = std::move(value);
has_services_ = true;
}



void BluetoothLEScanFilterInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_manufacturer_data_);
visitor->Trace(member_services_);
bindings::DictionaryBase::Trace(visitor);
}

void BluetoothLEScanFilterInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void BluetoothLEScanFilterInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasManufacturerData()) {
  values[0] = ToV8Traits<IDLSequence<BluetoothManufacturerDataFilterInit>>::ToV8(script_state, member_manufacturer_data_);
DCHECK(!values[0].IsEmpty());
}
if (hasName()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_name_);
DCHECK(!values[1].IsEmpty());
}
if (hasNamePrefix()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_name_prefix_);
DCHECK(!values[2].IsEmpty());
}
if (hasServices()) {
  values[3] = ToV8Traits<IDLSequence<V8UnionStringOrUnsignedLong>>::ToV8(script_state, member_services_);
DCHECK(!values[3].IsEmpty());
}
}

const void* BluetoothLEScanFilterInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> BluetoothLEScanFilterInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void BluetoothLEScanFilterInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "BluetoothLEScanFilterInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("manufacturerData");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<BluetoothManufacturerDataFilterInit>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_manufacturer_data_, member_manufacturer_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("namePrefix");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_name_prefix_, member_name_prefix_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("services");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionStringOrUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_services_, member_services_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> BluetoothLEScanFilterInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
