// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BACKGROUND_FETCH_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BACKGROUND_FETCH_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class BackgroundFetchRegistration;
class ExceptionState;

class MODULES_EXPORT BackgroundFetchEventInit : public ExtendableEventInit {
  
  public:
static BackgroundFetchEventInit* Create() {
  return MakeGarbageCollected<BackgroundFetchEventInit>();
}
static BackgroundFetchEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BackgroundFetchEventInit>(isolate);
}
static BackgroundFetchEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BackgroundFetchEventInit();
explicit  BackgroundFetchEventInit(v8::Isolate* isolate);

bool hasRegistration() const {
  return true;
}
BackgroundFetchRegistration* registration() const {
  return member_registration_.Get();
}
void setRegistration(BackgroundFetchRegistration* value) {
  member_registration_ = value;
DCHECK(member_registration_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<BackgroundFetchRegistration> member_registration_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BACKGROUND_FETCH_EVENT_INIT_H_
