// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authenticator_selection_criteria.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"authenticatorAttachment",
"requireResidentKey",
"residentKey",
"userVerification",
};


}  // namespace 

AuthenticatorSelectionCriteria* AuthenticatorSelectionCriteria::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticatorSelectionCriteria* dictionary = MakeGarbageCollected<AuthenticatorSelectionCriteria>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticatorSelectionCriteria";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria() {
  
}

 AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria(v8::Isolate* isolate) {
  
}



String AuthenticatorSelectionCriteria::getAuthenticatorAttachmentOr(const String& fallback_value) const {
  if (!hasAuthenticatorAttachment()) {
  return fallback_value;
}
return member_authenticator_attachment_;
}

String AuthenticatorSelectionCriteria::getAuthenticatorAttachmentOr(String&& fallback_value) const {
  if (!hasAuthenticatorAttachment()) {
  return std::move(fallback_value);
}
return member_authenticator_attachment_;
}

void AuthenticatorSelectionCriteria::setAuthenticatorAttachment(const String& value) {
  member_authenticator_attachment_ = value;
has_authenticator_attachment_ = true;
}

void AuthenticatorSelectionCriteria::setAuthenticatorAttachment(String&& value) {
  member_authenticator_attachment_ = std::move(value);
has_authenticator_attachment_ = true;
}









String AuthenticatorSelectionCriteria::getResidentKeyOr(const String& fallback_value) const {
  if (!hasResidentKey()) {
  return fallback_value;
}
return member_resident_key_;
}

String AuthenticatorSelectionCriteria::getResidentKeyOr(String&& fallback_value) const {
  if (!hasResidentKey()) {
  return std::move(fallback_value);
}
return member_resident_key_;
}

void AuthenticatorSelectionCriteria::setResidentKey(const String& value) {
  member_resident_key_ = value;
has_resident_key_ = true;
}

void AuthenticatorSelectionCriteria::setResidentKey(String&& value) {
  member_resident_key_ = std::move(value);
has_resident_key_ = true;
}




String AuthenticatorSelectionCriteria::getUserVerificationOr(const String& fallback_value) const {
  if (!hasUserVerification()) {
  return fallback_value;
}
return member_user_verification_;
}

String AuthenticatorSelectionCriteria::getUserVerificationOr(String&& fallback_value) const {
  if (!hasUserVerification()) {
  return std::move(fallback_value);
}
return member_user_verification_;
}

void AuthenticatorSelectionCriteria::setUserVerification(const String& value) {
  member_user_verification_ = value;
has_user_verification_ = true;
}

void AuthenticatorSelectionCriteria::setUserVerification(String&& value) {
  member_user_verification_ = std::move(value);
has_user_verification_ = true;
}



void AuthenticatorSelectionCriteria::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void AuthenticatorSelectionCriteria::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuthenticatorSelectionCriteria::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAuthenticatorAttachment()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_authenticator_attachment_);
DCHECK(!values[0].IsEmpty());
}
if (hasRequireResidentKey()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_require_resident_key_);
DCHECK(!values[1].IsEmpty());
}
if (hasResidentKey()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_resident_key_);
DCHECK(!values[2].IsEmpty());
}
if (hasUserVerification()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_user_verification_);
DCHECK(!values[3].IsEmpty());
}
}

const void* AuthenticatorSelectionCriteria::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuthenticatorSelectionCriteria::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuthenticatorSelectionCriteria::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticatorSelectionCriteria";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("authenticatorAttachment");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_authenticator_attachment_, member_authenticator_attachment_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requireResidentKey");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_require_resident_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("residentKey");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_resident_key_, member_resident_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("userVerification");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_user_verification_, member_user_verification_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticatorSelectionCriteria::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
