// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_worklet_node_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"numberOfInputs",
"numberOfOutputs",
"outputChannelCount",
"parameterData",
"processorOptions",
};


}  // namespace 

AudioWorkletNodeOptions* AudioWorkletNodeOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AudioWorkletNodeOptions* dictionary = MakeGarbageCollected<AudioWorkletNodeOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AudioWorkletNodeOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AudioWorkletNodeOptions::AudioWorkletNodeOptions() {
  
}

 AudioWorkletNodeOptions::AudioWorkletNodeOptions(v8::Isolate* isolate) : AudioNodeOptions(isolate) {
  
}













Vector<uint32_t> AudioWorkletNodeOptions::getOutputChannelCountOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasOutputChannelCount()) {
  return fallback_value;
}
return member_output_channel_count_;
}

Vector<uint32_t> AudioWorkletNodeOptions::getOutputChannelCountOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasOutputChannelCount()) {
  return std::move(fallback_value);
}
return member_output_channel_count_;
}

void AudioWorkletNodeOptions::setOutputChannelCount(const Vector<uint32_t>& value) {
  member_output_channel_count_ = value;
has_output_channel_count_ = true;
}

void AudioWorkletNodeOptions::setOutputChannelCount(Vector<uint32_t>&& value) {
  member_output_channel_count_ = std::move(value);
has_output_channel_count_ = true;
}




Vector<std::pair<String, double>> AudioWorkletNodeOptions::getParameterDataOr(const Vector<std::pair<String, double>>& fallback_value) const {
  if (!hasParameterData()) {
  return fallback_value;
}
return member_parameter_data_;
}

Vector<std::pair<String, double>> AudioWorkletNodeOptions::getParameterDataOr(Vector<std::pair<String, double>>&& fallback_value) const {
  if (!hasParameterData()) {
  return std::move(fallback_value);
}
return member_parameter_data_;
}

void AudioWorkletNodeOptions::setParameterData(const Vector<std::pair<String, double>>& value) {
  member_parameter_data_ = value;
has_parameter_data_ = true;
}

void AudioWorkletNodeOptions::setParameterData(Vector<std::pair<String, double>>&& value) {
  member_parameter_data_ = std::move(value);
has_parameter_data_ = true;
}










void AudioWorkletNodeOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_processor_options_);
AudioNodeOptions::Trace(visitor);
}

void AudioWorkletNodeOptions::FillTemplateProperties(Vector<std::string_view>& properties) const {
  AudioNodeOptions::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AudioWorkletNodeOptions::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  AudioNodeOptions::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasNumberOfInputs()) {
  values[0] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_number_of_inputs_);
DCHECK(!values[0].IsEmpty());
}
if (hasNumberOfOutputs()) {
  values[1] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_number_of_outputs_);
DCHECK(!values[1].IsEmpty());
}
if (hasOutputChannelCount()) {
  values[2] = ToV8Traits<IDLSequence<IDLUnsignedLong>>::ToV8(script_state, member_output_channel_count_);
DCHECK(!values[2].IsEmpty());
}
if (hasParameterData()) {
  values[3] = ToV8Traits<IDLRecord<IDLString, IDLDouble>>::ToV8(script_state, member_parameter_data_);
DCHECK(!values[3].IsEmpty());
}
if (hasProcessorOptions()) {
  values[4] = ToV8Traits<IDLObject>::ToV8(script_state, member_processor_options_);
DCHECK(!values[4].IsEmpty());
}
}

const void* AudioWorkletNodeOptions::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AudioWorkletNodeOptions::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AudioWorkletNodeOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
AudioNodeOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "AudioWorkletNodeOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("numberOfInputs");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_number_of_inputs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("numberOfOutputs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_number_of_outputs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("outputChannelCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_output_channel_count_, member_output_channel_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("parameterData");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_parameter_data_, member_parameter_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("processorOptions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_processor_options_, member_processor_options_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AudioWorkletNodeOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
