// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_TIMESTAMP_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_TIMESTAMP_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioTimestamp : public bindings::DictionaryBase {
  
  public:
static AudioTimestamp* Create() {
  return MakeGarbageCollected<AudioTimestamp>();
}
static AudioTimestamp* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioTimestamp>(isolate);
}
static AudioTimestamp* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioTimestamp();
explicit  AudioTimestamp(v8::Isolate* isolate);

bool hasContextTime() const {
  return has_context_time_;
}
double contextTime() const {
  DCHECK(hasContextTime());
return member_context_time_;
}
double getContextTimeOr(double fallback_value) const {
  if (!hasContextTime()) {
  return fallback_value;
}
return member_context_time_;
}
void setContextTime(double value) {
  member_context_time_ = value;
has_context_time_ = true;
}

bool hasPerformanceTime() const {
  return has_performance_time_;
}
double performanceTime() const {
  DCHECK(hasPerformanceTime());
return member_performance_time_;
}
double getPerformanceTimeOr(double fallback_value) const {
  if (!hasPerformanceTime()) {
  return fallback_value;
}
return member_performance_time_;
}
void setPerformanceTime(double value) {
  member_performance_time_ = value;
has_performance_time_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_context_time_ = false;
bool has_performance_time_ = false;

double member_context_time_;
double member_performance_time_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_TIMESTAMP_H_
