// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_SINK_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_SINK_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_sink_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioSinkOptions : public bindings::InputDictionaryBase {
  
  public:
static AudioSinkOptions* Create() {
  return MakeGarbageCollected<AudioSinkOptions>();
}
static AudioSinkOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioSinkOptions>(isolate);
}
static AudioSinkOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioSinkOptions();
explicit  AudioSinkOptions(v8::Isolate* isolate);

bool hasType() const {
  return true;
}
V8AudioSinkType type() const {
  return member_type_;
}
void setType(V8AudioSinkType value) {
  member_type_ = value;
}
void setType(V8AudioSinkType::Enum value) {
  member_type_ = V8AudioSinkType(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8AudioSinkType member_type_{static_cast<V8AudioSinkType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_SINK_OPTIONS_H_
