// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_configuration.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bitrate",
"channels",
"contentType",
"samplerate",
"spatialRendering",
};


}  // namespace 

AudioConfiguration* AudioConfiguration::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AudioConfiguration* dictionary = MakeGarbageCollected<AudioConfiguration>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AudioConfiguration";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AudioConfiguration::AudioConfiguration() {
  
}

 AudioConfiguration::AudioConfiguration(v8::Isolate* isolate) {
  
}










String AudioConfiguration::getChannelsOr(const String& fallback_value) const {
  if (!hasChannels()) {
  return fallback_value;
}
return member_channels_;
}

String AudioConfiguration::getChannelsOr(String&& fallback_value) const {
  if (!hasChannels()) {
  return std::move(fallback_value);
}
return member_channels_;
}

void AudioConfiguration::setChannels(const String& value) {
  member_channels_ = value;
has_channels_ = true;
}

void AudioConfiguration::setChannels(String&& value) {
  member_channels_ = std::move(value);
has_channels_ = true;
}




void AudioConfiguration::setContentType(const String& value) {
  member_content_type_ = value;
}

void AudioConfiguration::setContentType(String&& value) {
  member_content_type_ = std::move(value);
}

















void AudioConfiguration::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void AudioConfiguration::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AudioConfiguration";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bitrate");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_bitrate_, member_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("channels");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_channels_, member_channels_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contentType");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_content_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("samplerate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_samplerate_, member_samplerate_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::MediaCapabilitiesSpatialAudioEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("spatialRendering");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_spatial_rendering_, member_spatial_rendering_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> AudioConfiguration::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
