// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group_size.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_protected_audience_private_aggregation_config.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/deprecation/deprecation.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"adComponents",
"adSizes",
"additionalBidKey",
"ads",
"auctionServerRequestFlags",
"biddingLogicURL",
"biddingLogicUrl",
"biddingWasmHelperURL",
"biddingWasmHelperUrl",
"dailyUpdateUrl",
"enableBiddingSignalsPrioritization",
"executionMode",
"lifetimeMs",
"maxTrustedBiddingSignalsURLLength",
"name",
"owner",
"priority",
"prioritySignalsOverrides",
"priorityVector",
"privateAggregationConfig",
"sellerCapabilities",
"sizeGroups",
"trustedBiddingSignalsCoordinator",
"trustedBiddingSignalsKeys",
"trustedBiddingSignalsSlotSizeMode",
"trustedBiddingSignalsURL",
"trustedBiddingSignalsUrl",
"updateURL",
"updateUrl",
"userBiddingSignals",
"viewAndClickCountsProviders",
};


}  // namespace 

AuctionAdInterestGroup* AuctionAdInterestGroup::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuctionAdInterestGroup* dictionary = MakeGarbageCollected<AuctionAdInterestGroup>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuctionAdInterestGroup";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuctionAdInterestGroup::AuctionAdInterestGroup() {
  
}

 AuctionAdInterestGroup::AuctionAdInterestGroup(v8::Isolate* isolate) {
  
}



HeapVector<Member<AuctionAd>> AuctionAdInterestGroup::getAdComponentsOr(const HeapVector<Member<AuctionAd>>& fallback_value) const {
  if (!hasAdComponents()) {
  return fallback_value;
}
return member_ad_components_;
}

HeapVector<Member<AuctionAd>> AuctionAdInterestGroup::getAdComponentsOr(HeapVector<Member<AuctionAd>>&& fallback_value) const {
  if (!hasAdComponents()) {
  return std::move(fallback_value);
}
return member_ad_components_;
}

void AuctionAdInterestGroup::setAdComponents(const HeapVector<Member<AuctionAd>>& value) {
  member_ad_components_ = value;
has_ad_components_ = true;
}

void AuctionAdInterestGroup::setAdComponents(HeapVector<Member<AuctionAd>>&& value) {
  member_ad_components_ = std::move(value);
has_ad_components_ = true;
}




HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>> AuctionAdInterestGroup::getAdSizesOr(const HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>& fallback_value) const {
  if (!hasAdSizes()) {
  return fallback_value;
}
return member_ad_sizes_;
}

HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>> AuctionAdInterestGroup::getAdSizesOr(HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>&& fallback_value) const {
  if (!hasAdSizes()) {
  return std::move(fallback_value);
}
return member_ad_sizes_;
}

void AuctionAdInterestGroup::setAdSizes(const HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>& value) {
  member_ad_sizes_ = value;
has_ad_sizes_ = true;
}

void AuctionAdInterestGroup::setAdSizes(HeapVector<std::pair<String, Member<AuctionAdInterestGroupSize>>>&& value) {
  member_ad_sizes_ = std::move(value);
has_ad_sizes_ = true;
}




String AuctionAdInterestGroup::getAdditionalBidKeyOr(const String& fallback_value) const {
  if (!hasAdditionalBidKey()) {
  return fallback_value;
}
return member_additional_bid_key_;
}

String AuctionAdInterestGroup::getAdditionalBidKeyOr(String&& fallback_value) const {
  if (!hasAdditionalBidKey()) {
  return std::move(fallback_value);
}
return member_additional_bid_key_;
}

void AuctionAdInterestGroup::setAdditionalBidKey(const String& value) {
  member_additional_bid_key_ = value;
has_additional_bid_key_ = true;
}

void AuctionAdInterestGroup::setAdditionalBidKey(String&& value) {
  member_additional_bid_key_ = std::move(value);
has_additional_bid_key_ = true;
}




HeapVector<Member<AuctionAd>> AuctionAdInterestGroup::getAdsOr(const HeapVector<Member<AuctionAd>>& fallback_value) const {
  if (!hasAds()) {
  return fallback_value;
}
return member_ads_;
}

HeapVector<Member<AuctionAd>> AuctionAdInterestGroup::getAdsOr(HeapVector<Member<AuctionAd>>&& fallback_value) const {
  if (!hasAds()) {
  return std::move(fallback_value);
}
return member_ads_;
}

void AuctionAdInterestGroup::setAds(const HeapVector<Member<AuctionAd>>& value) {
  member_ads_ = value;
has_ads_ = true;
}

void AuctionAdInterestGroup::setAds(HeapVector<Member<AuctionAd>>&& value) {
  member_ads_ = std::move(value);
has_ads_ = true;
}




Vector<String> AuctionAdInterestGroup::getAuctionServerRequestFlagsOr(const Vector<String>& fallback_value) const {
  if (!hasAuctionServerRequestFlags()) {
  return fallback_value;
}
return member_auction_server_request_flags_;
}

Vector<String> AuctionAdInterestGroup::getAuctionServerRequestFlagsOr(Vector<String>&& fallback_value) const {
  if (!hasAuctionServerRequestFlags()) {
  return std::move(fallback_value);
}
return member_auction_server_request_flags_;
}

void AuctionAdInterestGroup::setAuctionServerRequestFlags(const Vector<String>& value) {
  member_auction_server_request_flags_ = value;
has_auction_server_request_flags_ = true;
}

void AuctionAdInterestGroup::setAuctionServerRequestFlags(Vector<String>&& value) {
  member_auction_server_request_flags_ = std::move(value);
has_auction_server_request_flags_ = true;
}




String AuctionAdInterestGroup::getBiddingLogicURLOr(const String& fallback_value) const {
  if (!hasBiddingLogicURL()) {
  return fallback_value;
}
return member_bidding_logic_url_;
}

String AuctionAdInterestGroup::getBiddingLogicURLOr(String&& fallback_value) const {
  if (!hasBiddingLogicURL()) {
  return std::move(fallback_value);
}
return member_bidding_logic_url_;
}

void AuctionAdInterestGroup::setBiddingLogicURL(const String& value) {
  member_bidding_logic_url_ = value;
has_bidding_logic_url_ = true;
}

void AuctionAdInterestGroup::setBiddingLogicURL(String&& value) {
  member_bidding_logic_url_ = std::move(value);
has_bidding_logic_url_ = true;
}




String AuctionAdInterestGroup::getBiddingLogicUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasBiddingLogicUrlDeprecated()) {
  return fallback_value;
}
return member_bidding_logic_url_deprecated_;
}

String AuctionAdInterestGroup::getBiddingLogicUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasBiddingLogicUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_bidding_logic_url_deprecated_;
}

void AuctionAdInterestGroup::setBiddingLogicUrlDeprecated(const String& value) {
  member_bidding_logic_url_deprecated_ = value;
has_bidding_logic_url_deprecated_ = true;
}

void AuctionAdInterestGroup::setBiddingLogicUrlDeprecated(String&& value) {
  member_bidding_logic_url_deprecated_ = std::move(value);
has_bidding_logic_url_deprecated_ = true;
}




String AuctionAdInterestGroup::getBiddingWasmHelperURLOr(const String& fallback_value) const {
  if (!hasBiddingWasmHelperURL()) {
  return fallback_value;
}
return member_bidding_wasm_helper_url_;
}

String AuctionAdInterestGroup::getBiddingWasmHelperURLOr(String&& fallback_value) const {
  if (!hasBiddingWasmHelperURL()) {
  return std::move(fallback_value);
}
return member_bidding_wasm_helper_url_;
}

void AuctionAdInterestGroup::setBiddingWasmHelperURL(const String& value) {
  member_bidding_wasm_helper_url_ = value;
has_bidding_wasm_helper_url_ = true;
}

void AuctionAdInterestGroup::setBiddingWasmHelperURL(String&& value) {
  member_bidding_wasm_helper_url_ = std::move(value);
has_bidding_wasm_helper_url_ = true;
}




String AuctionAdInterestGroup::getBiddingWasmHelperUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasBiddingWasmHelperUrlDeprecated()) {
  return fallback_value;
}
return member_bidding_wasm_helper_url_deprecated_;
}

String AuctionAdInterestGroup::getBiddingWasmHelperUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasBiddingWasmHelperUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_bidding_wasm_helper_url_deprecated_;
}

void AuctionAdInterestGroup::setBiddingWasmHelperUrlDeprecated(const String& value) {
  member_bidding_wasm_helper_url_deprecated_ = value;
has_bidding_wasm_helper_url_deprecated_ = true;
}

void AuctionAdInterestGroup::setBiddingWasmHelperUrlDeprecated(String&& value) {
  member_bidding_wasm_helper_url_deprecated_ = std::move(value);
has_bidding_wasm_helper_url_deprecated_ = true;
}




String AuctionAdInterestGroup::getDailyUpdateUrlOr(const String& fallback_value) const {
  if (!hasDailyUpdateUrl()) {
  return fallback_value;
}
return member_daily_update_url_;
}

String AuctionAdInterestGroup::getDailyUpdateUrlOr(String&& fallback_value) const {
  if (!hasDailyUpdateUrl()) {
  return std::move(fallback_value);
}
return member_daily_update_url_;
}

void AuctionAdInterestGroup::setDailyUpdateUrl(const String& value) {
  member_daily_update_url_ = value;
has_daily_update_url_ = true;
}

void AuctionAdInterestGroup::setDailyUpdateUrl(String&& value) {
  member_daily_update_url_ = std::move(value);
has_daily_update_url_ = true;
}











String AuctionAdInterestGroup::getExecutionModeOr(const String& fallback_value) const {
  if (!hasExecutionMode()) {
  return fallback_value;
}
return member_execution_mode_;
}

String AuctionAdInterestGroup::getExecutionModeOr(String&& fallback_value) const {
  if (!hasExecutionMode()) {
  return std::move(fallback_value);
}
return member_execution_mode_;
}

void AuctionAdInterestGroup::setExecutionMode(const String& value) {
  member_execution_mode_ = value;
has_execution_mode_ = true;
}

void AuctionAdInterestGroup::setExecutionMode(String&& value) {
  member_execution_mode_ = std::move(value);
has_execution_mode_ = true;
}


















void AuctionAdInterestGroup::setName(const String& value) {
  member_name_ = value;
}

void AuctionAdInterestGroup::setName(String&& value) {
  member_name_ = std::move(value);
}




void AuctionAdInterestGroup::setOwner(const String& value) {
  member_owner_ = value;
}

void AuctionAdInterestGroup::setOwner(String&& value) {
  member_owner_ = std::move(value);
}











Vector<std::pair<String, double>> AuctionAdInterestGroup::getPrioritySignalsOverridesOr(const Vector<std::pair<String, double>>& fallback_value) const {
  if (!hasPrioritySignalsOverrides()) {
  return fallback_value;
}
return member_priority_signals_overrides_;
}

Vector<std::pair<String, double>> AuctionAdInterestGroup::getPrioritySignalsOverridesOr(Vector<std::pair<String, double>>&& fallback_value) const {
  if (!hasPrioritySignalsOverrides()) {
  return std::move(fallback_value);
}
return member_priority_signals_overrides_;
}

void AuctionAdInterestGroup::setPrioritySignalsOverrides(const Vector<std::pair<String, double>>& value) {
  member_priority_signals_overrides_ = value;
has_priority_signals_overrides_ = true;
}

void AuctionAdInterestGroup::setPrioritySignalsOverrides(Vector<std::pair<String, double>>&& value) {
  member_priority_signals_overrides_ = std::move(value);
has_priority_signals_overrides_ = true;
}




Vector<std::pair<String, double>> AuctionAdInterestGroup::getPriorityVectorOr(const Vector<std::pair<String, double>>& fallback_value) const {
  if (!hasPriorityVector()) {
  return fallback_value;
}
return member_priority_vector_;
}

Vector<std::pair<String, double>> AuctionAdInterestGroup::getPriorityVectorOr(Vector<std::pair<String, double>>&& fallback_value) const {
  if (!hasPriorityVector()) {
  return std::move(fallback_value);
}
return member_priority_vector_;
}

void AuctionAdInterestGroup::setPriorityVector(const Vector<std::pair<String, double>>& value) {
  member_priority_vector_ = value;
has_priority_vector_ = true;
}

void AuctionAdInterestGroup::setPriorityVector(Vector<std::pair<String, double>>&& value) {
  member_priority_vector_ = std::move(value);
has_priority_vector_ = true;
}











Vector<std::pair<String, Vector<String>>> AuctionAdInterestGroup::getSellerCapabilitiesOr(const Vector<std::pair<String, Vector<String>>>& fallback_value) const {
  if (!hasSellerCapabilities()) {
  return fallback_value;
}
return member_seller_capabilities_;
}

Vector<std::pair<String, Vector<String>>> AuctionAdInterestGroup::getSellerCapabilitiesOr(Vector<std::pair<String, Vector<String>>>&& fallback_value) const {
  if (!hasSellerCapabilities()) {
  return std::move(fallback_value);
}
return member_seller_capabilities_;
}

void AuctionAdInterestGroup::setSellerCapabilities(const Vector<std::pair<String, Vector<String>>>& value) {
  member_seller_capabilities_ = value;
has_seller_capabilities_ = true;
}

void AuctionAdInterestGroup::setSellerCapabilities(Vector<std::pair<String, Vector<String>>>&& value) {
  member_seller_capabilities_ = std::move(value);
has_seller_capabilities_ = true;
}




Vector<std::pair<String, Vector<String>>> AuctionAdInterestGroup::getSizeGroupsOr(const Vector<std::pair<String, Vector<String>>>& fallback_value) const {
  if (!hasSizeGroups()) {
  return fallback_value;
}
return member_size_groups_;
}

Vector<std::pair<String, Vector<String>>> AuctionAdInterestGroup::getSizeGroupsOr(Vector<std::pair<String, Vector<String>>>&& fallback_value) const {
  if (!hasSizeGroups()) {
  return std::move(fallback_value);
}
return member_size_groups_;
}

void AuctionAdInterestGroup::setSizeGroups(const Vector<std::pair<String, Vector<String>>>& value) {
  member_size_groups_ = value;
has_size_groups_ = true;
}

void AuctionAdInterestGroup::setSizeGroups(Vector<std::pair<String, Vector<String>>>&& value) {
  member_size_groups_ = std::move(value);
has_size_groups_ = true;
}




String AuctionAdInterestGroup::getTrustedBiddingSignalsCoordinatorOr(const String& fallback_value) const {
  if (!hasTrustedBiddingSignalsCoordinator()) {
  return fallback_value;
}
return member_trusted_bidding_signals_coordinator_;
}

String AuctionAdInterestGroup::getTrustedBiddingSignalsCoordinatorOr(String&& fallback_value) const {
  if (!hasTrustedBiddingSignalsCoordinator()) {
  return std::move(fallback_value);
}
return member_trusted_bidding_signals_coordinator_;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsCoordinator(const String& value) {
  member_trusted_bidding_signals_coordinator_ = value;
has_trusted_bidding_signals_coordinator_ = true;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsCoordinator(String&& value) {
  member_trusted_bidding_signals_coordinator_ = std::move(value);
has_trusted_bidding_signals_coordinator_ = true;
}




Vector<String> AuctionAdInterestGroup::getTrustedBiddingSignalsKeysOr(const Vector<String>& fallback_value) const {
  if (!hasTrustedBiddingSignalsKeys()) {
  return fallback_value;
}
return member_trusted_bidding_signals_keys_;
}

Vector<String> AuctionAdInterestGroup::getTrustedBiddingSignalsKeysOr(Vector<String>&& fallback_value) const {
  if (!hasTrustedBiddingSignalsKeys()) {
  return std::move(fallback_value);
}
return member_trusted_bidding_signals_keys_;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsKeys(const Vector<String>& value) {
  member_trusted_bidding_signals_keys_ = value;
has_trusted_bidding_signals_keys_ = true;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsKeys(Vector<String>&& value) {
  member_trusted_bidding_signals_keys_ = std::move(value);
has_trusted_bidding_signals_keys_ = true;
}




String AuctionAdInterestGroup::getTrustedBiddingSignalsSlotSizeModeOr(const String& fallback_value) const {
  if (!hasTrustedBiddingSignalsSlotSizeMode()) {
  return fallback_value;
}
return member_trusted_bidding_signals_slot_size_mode_;
}

String AuctionAdInterestGroup::getTrustedBiddingSignalsSlotSizeModeOr(String&& fallback_value) const {
  if (!hasTrustedBiddingSignalsSlotSizeMode()) {
  return std::move(fallback_value);
}
return member_trusted_bidding_signals_slot_size_mode_;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsSlotSizeMode(const String& value) {
  member_trusted_bidding_signals_slot_size_mode_ = value;
has_trusted_bidding_signals_slot_size_mode_ = true;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsSlotSizeMode(String&& value) {
  member_trusted_bidding_signals_slot_size_mode_ = std::move(value);
has_trusted_bidding_signals_slot_size_mode_ = true;
}




String AuctionAdInterestGroup::getTrustedBiddingSignalsURLOr(const String& fallback_value) const {
  if (!hasTrustedBiddingSignalsURL()) {
  return fallback_value;
}
return member_trusted_bidding_signals_url_;
}

String AuctionAdInterestGroup::getTrustedBiddingSignalsURLOr(String&& fallback_value) const {
  if (!hasTrustedBiddingSignalsURL()) {
  return std::move(fallback_value);
}
return member_trusted_bidding_signals_url_;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsURL(const String& value) {
  member_trusted_bidding_signals_url_ = value;
has_trusted_bidding_signals_url_ = true;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsURL(String&& value) {
  member_trusted_bidding_signals_url_ = std::move(value);
has_trusted_bidding_signals_url_ = true;
}




String AuctionAdInterestGroup::getTrustedBiddingSignalsUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasTrustedBiddingSignalsUrlDeprecated()) {
  return fallback_value;
}
return member_trusted_bidding_signals_url_deprecated_;
}

String AuctionAdInterestGroup::getTrustedBiddingSignalsUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasTrustedBiddingSignalsUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_trusted_bidding_signals_url_deprecated_;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsUrlDeprecated(const String& value) {
  member_trusted_bidding_signals_url_deprecated_ = value;
has_trusted_bidding_signals_url_deprecated_ = true;
}

void AuctionAdInterestGroup::setTrustedBiddingSignalsUrlDeprecated(String&& value) {
  member_trusted_bidding_signals_url_deprecated_ = std::move(value);
has_trusted_bidding_signals_url_deprecated_ = true;
}




String AuctionAdInterestGroup::getUpdateURLOr(const String& fallback_value) const {
  if (!hasUpdateURL()) {
  return fallback_value;
}
return member_update_url_;
}

String AuctionAdInterestGroup::getUpdateURLOr(String&& fallback_value) const {
  if (!hasUpdateURL()) {
  return std::move(fallback_value);
}
return member_update_url_;
}

void AuctionAdInterestGroup::setUpdateURL(const String& value) {
  member_update_url_ = value;
has_update_url_ = true;
}

void AuctionAdInterestGroup::setUpdateURL(String&& value) {
  member_update_url_ = std::move(value);
has_update_url_ = true;
}




String AuctionAdInterestGroup::getUpdateUrlDeprecatedOr(const String& fallback_value) const {
  if (!hasUpdateUrlDeprecated()) {
  return fallback_value;
}
return member_update_url_deprecated_;
}

String AuctionAdInterestGroup::getUpdateUrlDeprecatedOr(String&& fallback_value) const {
  if (!hasUpdateUrlDeprecated()) {
  return std::move(fallback_value);
}
return member_update_url_deprecated_;
}

void AuctionAdInterestGroup::setUpdateUrlDeprecated(const String& value) {
  member_update_url_deprecated_ = value;
has_update_url_deprecated_ = true;
}

void AuctionAdInterestGroup::setUpdateUrlDeprecated(String&& value) {
  member_update_url_deprecated_ = std::move(value);
has_update_url_deprecated_ = true;
}











Vector<String> AuctionAdInterestGroup::getViewAndClickCountsProvidersOr(const Vector<String>& fallback_value) const {
  if (!hasViewAndClickCountsProviders()) {
  return fallback_value;
}
return member_view_and_click_counts_providers_;
}

Vector<String> AuctionAdInterestGroup::getViewAndClickCountsProvidersOr(Vector<String>&& fallback_value) const {
  if (!hasViewAndClickCountsProviders()) {
  return std::move(fallback_value);
}
return member_view_and_click_counts_providers_;
}

void AuctionAdInterestGroup::setViewAndClickCountsProviders(const Vector<String>& value) {
  member_view_and_click_counts_providers_ = value;
has_view_and_click_counts_providers_ = true;
}

void AuctionAdInterestGroup::setViewAndClickCountsProviders(Vector<String>&& value) {
  member_view_and_click_counts_providers_ = std::move(value);
has_view_and_click_counts_providers_ = true;
}



void AuctionAdInterestGroup::Trace(Visitor* visitor) const {
  visitor->Trace(member_ad_components_);
visitor->Trace(member_ad_sizes_);
visitor->Trace(member_ads_);
visitor->Trace(member_private_aggregation_config_);
visitor->Trace(member_user_bidding_signals_);
bindings::DictionaryBase::Trace(visitor);
}

void AuctionAdInterestGroup::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuctionAdInterestGroup::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAdComponents()) {
  values[0] = ToV8Traits<IDLSequence<AuctionAd>>::ToV8(script_state, member_ad_components_);
DCHECK(!values[0].IsEmpty());
}
if (hasAdSizes()) {
  values[1] = ToV8Traits<IDLRecord<IDLString, AuctionAdInterestGroupSize>>::ToV8(script_state, member_ad_sizes_);
DCHECK(!values[1].IsEmpty());
}
if (hasAdditionalBidKey()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_additional_bid_key_);
DCHECK(!values[2].IsEmpty());
}
if (hasAds()) {
  values[3] = ToV8Traits<IDLSequence<AuctionAd>>::ToV8(script_state, member_ads_);
DCHECK(!values[3].IsEmpty());
}
if (hasAuctionServerRequestFlags()) {
  values[4] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_auction_server_request_flags_);
DCHECK(!values[4].IsEmpty());
}
if (hasBiddingLogicURL()) {
  values[5] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_bidding_logic_url_);
DCHECK(!values[5].IsEmpty());
}
if (hasBiddingLogicUrlDeprecated()) {
  values[6] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_bidding_logic_url_deprecated_);
DCHECK(!values[6].IsEmpty());
}
if (hasBiddingWasmHelperURL()) {
  values[7] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_bidding_wasm_helper_url_);
DCHECK(!values[7].IsEmpty());
}
if (hasBiddingWasmHelperUrlDeprecated()) {
  values[8] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_bidding_wasm_helper_url_deprecated_);
DCHECK(!values[8].IsEmpty());
}
if (hasDailyUpdateUrl()) {
  values[9] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_daily_update_url_);
DCHECK(!values[9].IsEmpty());
}
if (hasEnableBiddingSignalsPrioritization()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_enable_bidding_signals_prioritization_);
DCHECK(!values[10].IsEmpty());
}
if (hasExecutionMode()) {
  values[11] = ToV8Traits<IDLString>::ToV8(script_state, member_execution_mode_);
DCHECK(!values[11].IsEmpty());
}
if (hasLifetimeMs()) {
  values[12] = ToV8Traits<IDLDouble>::ToV8(script_state, member_lifetime_ms_);
DCHECK(!values[12].IsEmpty());
}
if (hasMaxTrustedBiddingSignalsURLLength()) {
  values[13] = ToV8Traits<IDLLong>::ToV8(script_state, member_max_trusted_bidding_signals_url_length_);
DCHECK(!values[13].IsEmpty());
}
if (hasName()) {
  values[14] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_name_);
DCHECK(!values[14].IsEmpty());
}
if (hasOwner()) {
  values[15] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_owner_);
DCHECK(!values[15].IsEmpty());
}
if (hasPriority()) {
  values[16] = ToV8Traits<IDLDouble>::ToV8(script_state, member_priority_);
DCHECK(!values[16].IsEmpty());
}
if (hasPrioritySignalsOverrides()) {
  values[17] = ToV8Traits<IDLRecord<IDLUSVString, IDLDouble>>::ToV8(script_state, member_priority_signals_overrides_);
DCHECK(!values[17].IsEmpty());
}
if (hasPriorityVector()) {
  values[18] = ToV8Traits<IDLRecord<IDLUSVString, IDLDouble>>::ToV8(script_state, member_priority_vector_);
DCHECK(!values[18].IsEmpty());
}
if (hasPrivateAggregationConfig()) {
  values[19] = ToV8Traits<ProtectedAudiencePrivateAggregationConfig>::ToV8(script_state, member_private_aggregation_config_.Get());
DCHECK(!values[19].IsEmpty());
}
if (hasSellerCapabilities()) {
  values[20] = ToV8Traits<IDLRecord<IDLUSVString, IDLSequence<IDLString>>>::ToV8(script_state, member_seller_capabilities_);
DCHECK(!values[20].IsEmpty());
}
if (hasSizeGroups()) {
  values[21] = ToV8Traits<IDLRecord<IDLString, IDLSequence<IDLString>>>::ToV8(script_state, member_size_groups_);
DCHECK(!values[21].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2SupportEnabled()) {
  if (hasTrustedBiddingSignalsCoordinator()) {
  values[22] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_trusted_bidding_signals_coordinator_);
DCHECK(!values[22].IsEmpty());
}
}
if (hasTrustedBiddingSignalsKeys()) {
  values[23] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_trusted_bidding_signals_keys_);
DCHECK(!values[23].IsEmpty());
}
if (hasTrustedBiddingSignalsSlotSizeMode()) {
  values[24] = ToV8Traits<IDLString>::ToV8(script_state, member_trusted_bidding_signals_slot_size_mode_);
DCHECK(!values[24].IsEmpty());
}
if (hasTrustedBiddingSignalsURL()) {
  values[25] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_trusted_bidding_signals_url_);
DCHECK(!values[25].IsEmpty());
}
if (hasTrustedBiddingSignalsUrlDeprecated()) {
  values[26] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_trusted_bidding_signals_url_deprecated_);
DCHECK(!values[26].IsEmpty());
}
if (hasUpdateURL()) {
  values[27] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_update_url_);
DCHECK(!values[27].IsEmpty());
}
if (hasUpdateUrlDeprecated()) {
  values[28] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_update_url_deprecated_);
DCHECK(!values[28].IsEmpty());
}
if (hasUserBiddingSignals()) {
  values[29] = ToV8Traits<IDLAny>::ToV8(script_state, member_user_bidding_signals_);
DCHECK(!values[29].IsEmpty());
}
if (RuntimeEnabledFeatures::FledgeClickinessEnabled()) {
  if (hasViewAndClickCountsProviders()) {
  values[30] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_view_and_click_counts_providers_);
DCHECK(!values[30].IsEmpty());
}
}
}

const void* AuctionAdInterestGroup::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuctionAdInterestGroup::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuctionAdInterestGroup::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuctionAdInterestGroup";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("adComponents");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AuctionAd>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_ad_components_, member_ad_components_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("adSizes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, AuctionAdInterestGroupSize>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_ad_sizes_, member_ad_sizes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("additionalBidKey");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_additional_bid_key_, member_additional_bid_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ads");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<AuctionAd>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_ads_, member_ads_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("auctionServerRequestFlags");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_auction_server_request_flags_, member_auction_server_request_flags_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("biddingLogicURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_bidding_logic_url_, member_bidding_logic_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("biddingLogicUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_bidding_logic_url_deprecated_, member_bidding_logic_url_deprecated_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("biddingWasmHelperURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_bidding_wasm_helper_url_, member_bidding_wasm_helper_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("biddingWasmHelperUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_bidding_wasm_helper_url_deprecated_, member_bidding_wasm_helper_url_deprecated_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dailyUpdateUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_daily_update_url_, member_daily_update_url_, class_like_name, exception_state)) {
  return;
}
// [DeprecateAs]
bool has_deprecated;
if (!v8_dictionary->Has(current_context, v8_own_member_names[9].Get(isolate)).To(&has_deprecated)) {
  return;
}
if (has_deprecated) {
  ExecutionContext* execution_context = ExecutionContext::From(current_context);
Deprecation::CountDeprecation(execution_context, WebFeature::kDeprecatedInterestGroupDailyUpdateUrl);
}
dictionary_from_v8_context.SetCurrentPropertyName("enableBiddingSignalsPrioritization");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_enable_bidding_signals_prioritization_, member_enable_bidding_signals_prioritization_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("executionMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_execution_mode_, member_execution_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lifetimeMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_lifetime_ms_, member_lifetime_ms_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxTrustedBiddingSignalsURLLength");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_max_trusted_bidding_signals_url_length_, member_max_trusted_bidding_signals_url_length_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), fallback_presence_var, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("owner");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), fallback_presence_var, member_owner_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("priority");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_priority_, member_priority_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("prioritySignalsOverrides");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_priority_signals_overrides_, member_priority_signals_overrides_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("priorityVector");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_priority_vector_, member_priority_vector_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("privateAggregationConfig");
if (!bindings::GetDictionaryMemberFromV8Object<ProtectedAudiencePrivateAggregationConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_private_aggregation_config_, member_private_aggregation_config_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sellerCapabilities");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLSequence<IDLString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_seller_capabilities_, member_seller_capabilities_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sizeGroups");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLString, IDLSequence<IDLString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_size_groups_, member_size_groups_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2SupportEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("trustedBiddingSignalsCoordinator");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_trusted_bidding_signals_coordinator_, member_trusted_bidding_signals_coordinator_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("trustedBiddingSignalsKeys");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_trusted_bidding_signals_keys_, member_trusted_bidding_signals_keys_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("trustedBiddingSignalsSlotSizeMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_trusted_bidding_signals_slot_size_mode_, member_trusted_bidding_signals_slot_size_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("trustedBiddingSignalsURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_trusted_bidding_signals_url_, member_trusted_bidding_signals_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("trustedBiddingSignalsUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_trusted_bidding_signals_url_deprecated_, member_trusted_bidding_signals_url_deprecated_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("updateURL");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_update_url_, member_update_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("updateUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_update_url_deprecated_, member_update_url_deprecated_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("userBiddingSignals");
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), fallback_presence_var, member_user_bidding_signals_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FledgeClickinessEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("viewAndClickCountsProviders");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_view_and_click_counts_providers_, member_view_and_click_counts_providers_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> AuctionAdInterestGroup::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
