// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ANDROID_PAY_METHOD_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ANDROID_PAY_METHOD_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AndroidPayMethodData : public bindings::DictionaryBase {
  
  public:
static AndroidPayMethodData* Create() {
  return MakeGarbageCollected<AndroidPayMethodData>();
}
static AndroidPayMethodData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AndroidPayMethodData>(isolate);
}
static AndroidPayMethodData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AndroidPayMethodData();
explicit  AndroidPayMethodData(v8::Isolate* isolate);

bool hasApiVersion() const {
  return has_api_version_;
}
int32_t apiVersion() const {
  DCHECK(hasApiVersion());
return member_api_version_;
}
int32_t getApiVersionOr(int32_t fallback_value) const {
  if (!hasApiVersion()) {
  return fallback_value;
}
return member_api_version_;
}
void setApiVersion(int32_t value) {
  member_api_version_ = value;
has_api_version_ = true;
}

bool hasEnvironment() const {
  return has_environment_;
}
const String& environment() const {
  DCHECK(hasEnvironment());
return member_environment_;
}
String getEnvironmentOr(const String& fallback_value) const;
String getEnvironmentOr(String&& fallback_value) const;
void setEnvironment(const String& value);
void setEnvironment(String&& value);

bool hasMinGooglePlayServicesVersion() const {
  return has_min_google_play_services_version_;
}
const String& minGooglePlayServicesVersion() const {
  DCHECK(hasMinGooglePlayServicesVersion());
return member_min_google_play_services_version_;
}
String getMinGooglePlayServicesVersionOr(const String& fallback_value) const;
String getMinGooglePlayServicesVersionOr(String&& fallback_value) const;
void setMinGooglePlayServicesVersion(const String& value);
void setMinGooglePlayServicesVersion(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_api_version_ = false;
bool has_environment_ = false;
bool has_min_google_play_services_version_ = false;

int32_t member_api_version_;
String member_environment_;
String member_min_google_play_services_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ANDROID_PAY_METHOD_DATA_H_
