// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ALL_ACCEPTED_CREDENTIALS_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ALL_ACCEPTED_CREDENTIALS_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AllAcceptedCredentialsOptions : public bindings::InputDictionaryBase {
  
  public:
static AllAcceptedCredentialsOptions* Create() {
  return MakeGarbageCollected<AllAcceptedCredentialsOptions>();
}
static AllAcceptedCredentialsOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AllAcceptedCredentialsOptions>(isolate);
}
static AllAcceptedCredentialsOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AllAcceptedCredentialsOptions();
explicit  AllAcceptedCredentialsOptions(v8::Isolate* isolate);

bool hasAllAcceptedCredentialIds() const {
  return true;
}
const Vector<String>& allAcceptedCredentialIds() const {
  return member_all_accepted_credential_ids_;
}
void setAllAcceptedCredentialIds(const Vector<String>& value);
void setAllAcceptedCredentialIds(Vector<String>&& value);

bool hasRpId() const {
  return true;
}
const String& rpId() const {
  return member_rp_id_;
}
void setRpId(const String& value);
void setRpId(String&& value);

bool hasUserId() const {
  return true;
}
const String& userId() const {
  return member_user_id_;
}
void setUserId(const String& value);
void setUserId(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Vector<String> member_all_accepted_credential_ids_;
String member_rp_id_;
String member_user_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ALL_ACCEPTED_CREDENTIALS_OPTIONS_H_
