// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_result.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_urlpatterninit_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_component_result.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_init.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"hash",
"hostname",
"inputs",
"password",
"pathname",
"port",
"protocol",
"search",
"username",
};


}  // namespace 

URLPatternResult* URLPatternResult::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  URLPatternResult* dictionary = MakeGarbageCollected<URLPatternResult>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "URLPatternResult";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 URLPatternResult::URLPatternResult() {
  
}

 URLPatternResult::URLPatternResult(v8::Isolate* isolate) {
  
}

















HeapVector<Member<V8UnionURLPatternInitOrUSVString>> URLPatternResult::getInputsOr(const HeapVector<Member<V8UnionURLPatternInitOrUSVString>>& fallback_value) const {
  if (!hasInputs()) {
  return fallback_value;
}
return member_inputs_;
}

HeapVector<Member<V8UnionURLPatternInitOrUSVString>> URLPatternResult::getInputsOr(HeapVector<Member<V8UnionURLPatternInitOrUSVString>>&& fallback_value) const {
  if (!hasInputs()) {
  return std::move(fallback_value);
}
return member_inputs_;
}

void URLPatternResult::setInputs(const HeapVector<Member<V8UnionURLPatternInitOrUSVString>>& value) {
  member_inputs_ = value;
has_inputs_ = true;
}

void URLPatternResult::setInputs(HeapVector<Member<V8UnionURLPatternInitOrUSVString>>&& value) {
  member_inputs_ = std::move(value);
has_inputs_ = true;
}













































void URLPatternResult::Trace(Visitor* visitor) const {
  visitor->Trace(member_hash_);
visitor->Trace(member_hostname_);
visitor->Trace(member_inputs_);
visitor->Trace(member_password_);
visitor->Trace(member_pathname_);
visitor->Trace(member_port_);
visitor->Trace(member_protocol_);
visitor->Trace(member_search_);
visitor->Trace(member_username_);
bindings::DictionaryBase::Trace(visitor);
}

void URLPatternResult::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void URLPatternResult::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasHash()) {
  values[0] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_hash_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasHostname()) {
  values[1] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_hostname_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasInputs()) {
  values[2] = ToV8Traits<IDLSequence<V8UnionURLPatternInitOrUSVString>>::ToV8(script_state, member_inputs_);
DCHECK(!values[2].IsEmpty());
}
if (hasPassword()) {
  values[3] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_password_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasPathname()) {
  values[4] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_pathname_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasPort()) {
  values[5] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_port_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasProtocol()) {
  values[6] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_protocol_.Get());
DCHECK(!values[6].IsEmpty());
}
if (hasSearch()) {
  values[7] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_search_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasUsername()) {
  values[8] = ToV8Traits<URLPatternComponentResult>::ToV8(script_state, member_username_.Get());
DCHECK(!values[8].IsEmpty());
}
}

const void* URLPatternResult::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> URLPatternResult::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void URLPatternResult::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "URLPatternResult";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("hash");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_hash_, member_hash_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hostname");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_hostname_, member_hostname_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("inputs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionURLPatternInitOrUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_inputs_, member_inputs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("password");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_password_, member_password_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pathname");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_pathname_, member_pathname_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("port");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_port_, member_port_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("protocol");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_protocol_, member_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("search");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_search_, member_search_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("username");
if (!bindings::GetDictionaryMemberFromV8Object<URLPatternComponentResult, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_username_, member_username_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> URLPatternResult::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
