// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_urlpattern_urlpatterninit_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_urlpatterninit_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_init.h"
#include "third_party/blink/renderer/core/url_pattern/url_pattern.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionURLPatternOrURLPatternInitOrUSVString* V8UnionURLPatternOrURLPatternInitOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = URLPatternInit::Create(isolate);
return MakeGarbageCollected<V8UnionURLPatternOrURLPatternInitOrUSVString>(blink_value);
}
if (V8URLPattern::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8URLPattern::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionURLPatternOrURLPatternInitOrUSVString>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<URLPatternInit>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionURLPatternOrURLPatternInitOrUSVString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionURLPatternOrURLPatternInitOrUSVString>(std::move(blink_value));
}
}

 V8UnionURLPatternOrURLPatternInitOrUSVString::V8UnionURLPatternOrURLPatternInitOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionURLPatternOrURLPatternInitOrUSVString::V8UnionURLPatternOrURLPatternInitOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}










void V8UnionURLPatternOrURLPatternInitOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionURLPatternOrURLPatternInitOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


V8UnionURLPatternInitOrUSVString* V8UnionURLPatternOrURLPatternInitOrUSVString::GetAsV8UnionURLPatternInitOrUSVString() const {
  switch (content_type_) {
  case ContentType::kURLPatternInit: {
    return MakeGarbageCollected<V8UnionURLPatternInitOrUSVString>(GetAsURLPatternInit());
  }
  case ContentType::kUSVString: {
    return MakeGarbageCollected<V8UnionURLPatternInitOrUSVString>(GetAsUSVString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionURLPatternOrURLPatternInitOrUSVString::Set(const V8UnionURLPatternInitOrUSVString* value) {
  switch (value->GetContentType()) {
  case V8UnionURLPatternInitOrUSVString::ContentType::kURLPatternInit: {
    Set(value->GetAsURLPatternInit());
    break;
  }
  case V8UnionURLPatternInitOrUSVString::ContentType::kUSVString: {
    Set(value->GetAsUSVString());
    break;
  }
}
}




void V8UnionURLPatternOrURLPatternInitOrUSVString::Trace(Visitor* visitor) const {
  visitor->Trace(member_url_pattern_);
visitor->Trace(member_url_pattern_init_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionURLPatternOrURLPatternInitOrUSVString::Clear() {
  member_url_pattern_.Clear();
member_url_pattern_init_.Clear();
member_usv_string_ = String();
}



}  // namespace blink
