// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_opaqueproperty_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionOpaquePropertyOrUSVString* V8UnionOpaquePropertyOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  {
  auto&& blink_value = NativeValueTraits<V8OpaqueProperty>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionOpaquePropertyOrUSVString>(blink_value);
}
}

 V8UnionOpaquePropertyOrUSVString::V8UnionOpaquePropertyOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionOpaquePropertyOrUSVString::V8UnionOpaquePropertyOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}







void V8UnionOpaquePropertyOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionOpaquePropertyOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


void V8UnionOpaquePropertyOrUSVString::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionOpaquePropertyOrUSVString::Clear() {
  member_usv_string_ = String();
}



}  // namespace blink
