// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLCANVASELEMENT_OFFSCREENCANVAS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLCANVASELEMENT_OFFSCREENCANVAS_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLCanvasElement;
class OffscreenCanvas;
class ScriptState;

class CORE_EXPORT V8UnionHTMLCanvasElementOrOffscreenCanvas final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kHTMLCanvasElement, kOffscreenCanvas
};

static V8UnionHTMLCanvasElementOrOffscreenCanvas* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionHTMLCanvasElementOrOffscreenCanvas(HTMLCanvasElement* value) : content_type_(ContentType::kHTMLCanvasElement), member_html_canvas_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrOffscreenCanvas(OffscreenCanvas* value) : content_type_(ContentType::kOffscreenCanvas), member_offscreen_canvas_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsHTMLCanvasElement() const {
  return content_type_ == ContentType::kHTMLCanvasElement;
}
HTMLCanvasElement* GetAsHTMLCanvasElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLCanvasElement);
return member_html_canvas_element_.Get();
}
void Set(HTMLCanvasElement* value) {
  DCHECK(value);
Clear();
member_html_canvas_element_ = value;
content_type_ = ContentType::kHTMLCanvasElement;
}

bool IsOffscreenCanvas() const {
  return content_type_ == ContentType::kOffscreenCanvas;
}
OffscreenCanvas* GetAsOffscreenCanvas() const {
  DCHECK_EQ(content_type_, ContentType::kOffscreenCanvas);
return member_offscreen_canvas_.Get();
}
void Set(OffscreenCanvas* value) {
  DCHECK(value);
Clear();
member_offscreen_canvas_ = value;
content_type_ = ContentType::kOffscreenCanvas;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(HTMLCanvasElement or OffscreenCanvas)";
}

ContentType content_type_;

Member<HTMLCanvasElement> member_html_canvas_element_;
Member<OffscreenCanvas> member_offscreen_canvas_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLCANVASELEMENT_OFFSCREENCANVAS_H_
