// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string_stringsequence.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_stringsequence.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDoubleOrStringOrStringSequence* V8UnionDoubleOrStringOrStringSequence::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<IDLString>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrStringSequence>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<IDLString>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrStringSequence>(std::move(blink_value));
}
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrStringSequence>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleOrStringOrStringSequence>(std::move(blink_value));
}
}

 V8UnionDoubleOrStringOrStringSequence::V8UnionDoubleOrStringOrStringSequence(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionDoubleOrStringOrStringSequence::V8UnionDoubleOrStringOrStringSequence(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}

 V8UnionDoubleOrStringOrStringSequence::V8UnionDoubleOrStringOrStringSequence(const Vector<String>& value) : content_type_(ContentType::kStringSequence), member_string_sequence_(value) {
  
}

 V8UnionDoubleOrStringOrStringSequence::V8UnionDoubleOrStringOrStringSequence(Vector<String>&& value) : content_type_(ContentType::kStringSequence), member_string_sequence_(std::move(value)) {
  
}







void V8UnionDoubleOrStringOrStringSequence::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionDoubleOrStringOrStringSequence::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}



void V8UnionDoubleOrStringOrStringSequence::Set(const Vector<String>& value) {
  Clear();
member_string_sequence_ = value;
content_type_ = ContentType::kStringSequence;
}

void V8UnionDoubleOrStringOrStringSequence::Set(Vector<String>&& value) {
  Clear();
member_string_sequence_ = std::move(value);
content_type_ = ContentType::kStringSequence;
}


V8UnionDoubleOrString* V8UnionDoubleOrStringOrStringSequence::GetAsV8UnionDoubleOrString() const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return MakeGarbageCollected<V8UnionDoubleOrString>(GetAsDouble());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionDoubleOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrStringOrStringSequence::Set(const V8UnionDoubleOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionDoubleOrString::ContentType::kDouble: {
    Set(value->GetAsDouble());
    break;
  }
  case V8UnionDoubleOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionStringOrStringSequence* V8UnionDoubleOrStringOrStringSequence::GetAsV8UnionStringOrStringSequence() const {
  switch (content_type_) {
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionStringOrStringSequence>(GetAsString());
  }
  case ContentType::kStringSequence: {
    return MakeGarbageCollected<V8UnionStringOrStringSequence>(GetAsStringSequence());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionDoubleOrStringOrStringSequence::Set(const V8UnionStringOrStringSequence* value) {
  switch (value->GetContentType()) {
  case V8UnionStringOrStringSequence::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
  case V8UnionStringOrStringSequence::ContentType::kStringSequence: {
    Set(value->GetAsStringSequence());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionDoubleOrStringOrStringSequence::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kDouble: {
    return ToV8Traits<IDLDouble>::ToV8(script_state, member_double_);
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kStringSequence: {
    return ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_string_sequence_);
  }
}

NOTREACHED();
}

void V8UnionDoubleOrStringOrStringSequence::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionDoubleOrStringOrStringSequence::Clear() {
  member_double_ = 0;
member_string_ = String();
member_string_sequence_.clear();
}



}  // namespace blink
