// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_string_unrestricteddouble.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_string.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionBooleanOrStringOrUnrestrictedDouble* V8UnionBooleanOrStringOrUnrestrictedDouble::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsBoolean()) {
  auto&& blink_value = v8_value.As<v8::Boolean>()->Value();
return MakeGarbageCollected<V8UnionBooleanOrStringOrUnrestrictedDouble>(blink_value);
}
if (v8_value->IsNumber()) {
  auto&& blink_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrStringOrUnrestrictedDouble>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrStringOrUnrestrictedDouble>(std::move(blink_value));
}
}

 V8UnionBooleanOrStringOrUnrestrictedDouble::V8UnionBooleanOrStringOrUnrestrictedDouble(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionBooleanOrStringOrUnrestrictedDouble::V8UnionBooleanOrStringOrUnrestrictedDouble(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionBooleanOrStringOrUnrestrictedDouble::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionBooleanOrStringOrUnrestrictedDouble::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}





V8UnionBooleanOrString* V8UnionBooleanOrStringOrUnrestrictedDouble::GetAsV8UnionBooleanOrString() const {
  switch (content_type_) {
  case ContentType::kBoolean: {
    return MakeGarbageCollected<V8UnionBooleanOrString>(GetAsBoolean());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionBooleanOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionBooleanOrStringOrUnrestrictedDouble::Set(const V8UnionBooleanOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionBooleanOrString::ContentType::kBoolean: {
    Set(value->GetAsBoolean());
    break;
  }
  case V8UnionBooleanOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionBooleanOrStringOrUnrestrictedDouble::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kBoolean: {
    return ToV8Traits<IDLBoolean>::ToV8(script_state, member_boolean_);
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kUnrestrictedDouble: {
    return ToV8Traits<IDLUnrestrictedDouble>::ToV8(script_state, member_unrestricted_double_);
  }
}

NOTREACHED();
}

void V8UnionBooleanOrStringOrUnrestrictedDouble::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionBooleanOrStringOrUnrestrictedDouble::Clear() {
  member_boolean_ = false;
member_string_ = String();
member_unrestricted_double_ = 0;
}



}  // namespace blink
