// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BIGINT_UNRESTRICTEDDOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BIGINT_UNRESTRICTEDDOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionBigintOrUnrestrictedDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kBigint, kUnrestrictedDouble
};

static V8UnionBigintOrUnrestrictedDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionBigintOrUnrestrictedDouble(const BigInt& value) : content_type_(ContentType::kBigint), member_bigint_(value) {
  
}
explicit  V8UnionBigintOrUnrestrictedDouble(double value) : content_type_(ContentType::kUnrestrictedDouble), member_unrestricted_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsBigint() const {
  return content_type_ == ContentType::kBigint;
}
const BigInt& GetAsBigint() const {
  DCHECK_EQ(content_type_, ContentType::kBigint);
return member_bigint_;
}
void Set(const BigInt& value) {
  Clear();
member_bigint_ = value;
content_type_ = ContentType::kBigint;
}

bool IsUnrestrictedDouble() const {
  return content_type_ == ContentType::kUnrestrictedDouble;
}
double GetAsUnrestrictedDouble() const {
  DCHECK_EQ(content_type_, ContentType::kUnrestrictedDouble);
return member_unrestricted_double_;
}
void Set(double value) {
  Clear();
member_unrestricted_double_ = value;
content_type_ = ContentType::kUnrestrictedDouble;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(bigint or unrestricted double)";
}

ContentType content_type_;

BigInt member_bigint_;
double member_unrestricted_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_BIGINT_UNRESTRICTEDDOUBLE_H_
