// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_blob_formdata_urlsearchparams_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_form_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_blob_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_search_params.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/core/html/forms/form_data.h"
#include "third_party/blink/renderer/core/url/url_search_params.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString* V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8URLSearchParams::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8URLSearchParams::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString>(blink_value);
}
if (V8FormData::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8FormData::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString>(blink_value);
}
if (V8Blob::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Blob::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString>(blink_value);
}
if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString>(blink_value);
}
if (v8_value->IsArrayBufferView()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMArrayBufferView>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString>(std::move(blink_value));
}
}

 V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}



















void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


V8UnionArrayBufferOrArrayBufferView* V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::GetAsV8UnionArrayBufferOrArrayBufferView() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBufferView());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Set(const V8UnionArrayBufferOrArrayBufferView* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
}
}






V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::GetAsV8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(GetAsArrayBufferView());
  }
  case ContentType::kBlob: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(GetAsBlob());
  }
  case ContentType::kUSVString: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>(GetAsUSVString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Set(const V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::ContentType::kBlob: {
    Set(value->GetAsBlob());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString::ContentType::kUSVString: {
    Set(value->GetAsUSVString());
    break;
  }
}
}




V8UnionArrayBufferOrArrayBufferViewOrUSVString* V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::GetAsV8UnionArrayBufferOrArrayBufferViewOrUSVString() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrUSVString>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrUSVString>(GetAsArrayBufferView());
  }
  case ContentType::kUSVString: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrUSVString>(GetAsUSVString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Set(const V8UnionArrayBufferOrArrayBufferViewOrUSVString* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferViewOrUSVString::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrUSVString::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrUSVString::ContentType::kUSVString: {
    Set(value->GetAsUSVString());
    break;
  }
}
}




void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_);
visitor->Trace(member_array_buffer_view_);
visitor->Trace(member_blob_);
visitor->Trace(member_form_data_);
visitor->Trace(member_url_search_params_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString::Clear() {
  member_array_buffer_.Clear();
member_array_buffer_view_.Clear();
member_blob_.Clear();
member_form_data_.Clear();
member_url_search_params_.Clear();
member_usv_string_ = String();
}



}  // namespace blink
