// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_underlying_source_cancel_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8UnderlyingSourceCancelCallback::GetHumanReadableName() const {
  return "V8UnderlyingSourceCancelCallback";
}

v8::Maybe<ScriptPromise<IDLUndefined>> V8UnderlyingSourceCancelCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const ScriptValue& arg1_reason) {
  const char* const class_like_name = "UnderlyingSourceCancelCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptPromise<IDLUndefined>>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptPromise<IDLUndefined>>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kYes> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptPromise<IDLUndefined>>();
}
return helper.Result<IDLPromise<IDLUndefined>, ScriptPromise<IDLUndefined>>();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_reason;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_reason = ToV8Traits<IDLOptional<IDLAny>>::ToV8(script_state, arg1_reason);
argv[0] = v8_arg1_reason;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptPromise<IDLUndefined>>();
}
return helper.Result<IDLPromise<IDLUndefined>, ScriptPromise<IDLUndefined>>();
}

v8::Maybe<ScriptPromise<IDLUndefined>> V8UnderlyingSourceCancelCallback::Construct(const ScriptValue& arg1_reason) {
  const char* const class_like_name = "UnderlyingSourceCancelCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptPromise<IDLUndefined>>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptPromise<IDLUndefined>>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kYes> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptPromise<IDLUndefined>>();
}
return helper.Result<IDLPromise<IDLUndefined>, ScriptPromise<IDLUndefined>>();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_reason;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_reason = ToV8Traits<IDLOptional<IDLAny>>::ToV8(script_state, arg1_reason);
argv[0] = v8_arg1_reason;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptPromise<IDLUndefined>>();
}
return helper.Result<IDLPromise<IDLUndefined>, ScriptPromise<IDLUndefined>>();
}




}  // namespace blink
