// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_underlying_source.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_underlying_source_cancel_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_underlying_source_pull_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_underlying_source_start_callback.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"autoAllocateChunkSize",
"cancel",
"pull",
"start",
"type",
};


}  // namespace 

UnderlyingSource* UnderlyingSource::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  UnderlyingSource* dictionary = MakeGarbageCollected<UnderlyingSource>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "UnderlyingSource";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 UnderlyingSource::UnderlyingSource() {
  
}

 UnderlyingSource::UnderlyingSource(v8::Isolate* isolate) {
  
}





































void UnderlyingSource::Trace(Visitor* visitor) const {
  visitor->Trace(member_cancel_);
visitor->Trace(member_pull_);
visitor->Trace(member_start_);
bindings::DictionaryBase::Trace(visitor);
}

void UnderlyingSource::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void UnderlyingSource::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAutoAllocateChunkSize()) {
  values[0] = ToV8Traits<IDLUnsignedLongLongEnforceRange>::ToV8(script_state, member_auto_allocate_chunk_size_);
DCHECK(!values[0].IsEmpty());
}
if (hasCancel()) {
  values[1] = ToV8Traits<V8UnderlyingSourceCancelCallback>::ToV8(script_state, member_cancel_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasPull()) {
  values[2] = ToV8Traits<V8UnderlyingSourcePullCallback>::ToV8(script_state, member_pull_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasStart()) {
  values[3] = ToV8Traits<V8UnderlyingSourceStartCallback>::ToV8(script_state, member_start_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasType()) {
  values[4] = ToV8Traits<V8ReadableStreamType>::ToV8(script_state, member_type_);
DCHECK(!values[4].IsEmpty());
}
}

const void* UnderlyingSource::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> UnderlyingSource::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void UnderlyingSource::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "UnderlyingSource";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("autoAllocateChunkSize");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_auto_allocate_chunk_size_, member_auto_allocate_chunk_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("cancel");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnderlyingSourceCancelCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_cancel_, member_cancel_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pull");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnderlyingSourcePullCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_pull_, member_pull_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("start");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnderlyingSourceStartCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_start_, member_start_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8ReadableStreamType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> UnderlyingSource::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
