// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UI_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UI_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMWindow;
class ExceptionState;
class InputDeviceCapabilities;

class CORE_EXPORT UIEventInit : public EventInit {
  
  public:
static UIEventInit* Create() {
  return MakeGarbageCollected<UIEventInit>();
}
static UIEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UIEventInit>(isolate);
}
static UIEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UIEventInit();
explicit  UIEventInit(v8::Isolate* isolate);

bool hasDetail() const {
  return true;
}
int32_t detail() const {
  return member_detail_;
}
void setDetail(int32_t value) {
  member_detail_ = value;
}

bool hasSourceCapabilities() const {
  return true;
}
InputDeviceCapabilities* sourceCapabilities() const {
  return member_source_capabilities_.Get();
}
void setSourceCapabilities(InputDeviceCapabilities* value) {
  member_source_capabilities_ = value;
}

bool hasView() const {
  return true;
}
DOMWindow* view() const {
  return member_view_.Get();
}
void setView(DOMWindow* value) {
  member_view_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



int32_t member_detail_{0};
Member<InputDeviceCapabilities> member_source_capabilities_{nullptr};
Member<DOMWindow> member_view_{nullptr};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UI_EVENT_INIT_H_
