// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_ua_data_values.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigator_ua_brand_version.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"architecture",
"bitness",
"brands",
"formFactors",
"fullVersionList",
"mobile",
"model",
"platform",
"platformVersion",
"uaFullVersion",
"wow64",
};


}  // namespace 

UADataValues* UADataValues::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  UADataValues* dictionary = MakeGarbageCollected<UADataValues>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "UADataValues";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 UADataValues::UADataValues() {
  
}

 UADataValues::UADataValues(v8::Isolate* isolate) {
  
}



String UADataValues::getArchitectureOr(const String& fallback_value) const {
  if (!hasArchitecture()) {
  return fallback_value;
}
return member_architecture_;
}

String UADataValues::getArchitectureOr(String&& fallback_value) const {
  if (!hasArchitecture()) {
  return std::move(fallback_value);
}
return member_architecture_;
}

void UADataValues::setArchitecture(const String& value) {
  member_architecture_ = value;
has_architecture_ = true;
}

void UADataValues::setArchitecture(String&& value) {
  member_architecture_ = std::move(value);
has_architecture_ = true;
}




String UADataValues::getBitnessOr(const String& fallback_value) const {
  if (!hasBitness()) {
  return fallback_value;
}
return member_bitness_;
}

String UADataValues::getBitnessOr(String&& fallback_value) const {
  if (!hasBitness()) {
  return std::move(fallback_value);
}
return member_bitness_;
}

void UADataValues::setBitness(const String& value) {
  member_bitness_ = value;
has_bitness_ = true;
}

void UADataValues::setBitness(String&& value) {
  member_bitness_ = std::move(value);
has_bitness_ = true;
}




HeapVector<Member<NavigatorUABrandVersion>> UADataValues::getBrandsOr(const HeapVector<Member<NavigatorUABrandVersion>>& fallback_value) const {
  if (!hasBrands()) {
  return fallback_value;
}
return member_brands_;
}

HeapVector<Member<NavigatorUABrandVersion>> UADataValues::getBrandsOr(HeapVector<Member<NavigatorUABrandVersion>>&& fallback_value) const {
  if (!hasBrands()) {
  return std::move(fallback_value);
}
return member_brands_;
}

void UADataValues::setBrands(const HeapVector<Member<NavigatorUABrandVersion>>& value) {
  member_brands_ = value;
has_brands_ = true;
}

void UADataValues::setBrands(HeapVector<Member<NavigatorUABrandVersion>>&& value) {
  member_brands_ = std::move(value);
has_brands_ = true;
}




Vector<String> UADataValues::getFormFactorsOr(const Vector<String>& fallback_value) const {
  if (!hasFormFactors()) {
  return fallback_value;
}
return member_form_factors_;
}

Vector<String> UADataValues::getFormFactorsOr(Vector<String>&& fallback_value) const {
  if (!hasFormFactors()) {
  return std::move(fallback_value);
}
return member_form_factors_;
}

void UADataValues::setFormFactors(const Vector<String>& value) {
  member_form_factors_ = value;
has_form_factors_ = true;
}

void UADataValues::setFormFactors(Vector<String>&& value) {
  member_form_factors_ = std::move(value);
has_form_factors_ = true;
}




HeapVector<Member<NavigatorUABrandVersion>> UADataValues::getFullVersionListOr(const HeapVector<Member<NavigatorUABrandVersion>>& fallback_value) const {
  if (!hasFullVersionList()) {
  return fallback_value;
}
return member_full_version_list_;
}

HeapVector<Member<NavigatorUABrandVersion>> UADataValues::getFullVersionListOr(HeapVector<Member<NavigatorUABrandVersion>>&& fallback_value) const {
  if (!hasFullVersionList()) {
  return std::move(fallback_value);
}
return member_full_version_list_;
}

void UADataValues::setFullVersionList(const HeapVector<Member<NavigatorUABrandVersion>>& value) {
  member_full_version_list_ = value;
has_full_version_list_ = true;
}

void UADataValues::setFullVersionList(HeapVector<Member<NavigatorUABrandVersion>>&& value) {
  member_full_version_list_ = std::move(value);
has_full_version_list_ = true;
}











String UADataValues::getModelOr(const String& fallback_value) const {
  if (!hasModel()) {
  return fallback_value;
}
return member_model_;
}

String UADataValues::getModelOr(String&& fallback_value) const {
  if (!hasModel()) {
  return std::move(fallback_value);
}
return member_model_;
}

void UADataValues::setModel(const String& value) {
  member_model_ = value;
has_model_ = true;
}

void UADataValues::setModel(String&& value) {
  member_model_ = std::move(value);
has_model_ = true;
}




String UADataValues::getPlatformOr(const String& fallback_value) const {
  if (!hasPlatform()) {
  return fallback_value;
}
return member_platform_;
}

String UADataValues::getPlatformOr(String&& fallback_value) const {
  if (!hasPlatform()) {
  return std::move(fallback_value);
}
return member_platform_;
}

void UADataValues::setPlatform(const String& value) {
  member_platform_ = value;
has_platform_ = true;
}

void UADataValues::setPlatform(String&& value) {
  member_platform_ = std::move(value);
has_platform_ = true;
}




String UADataValues::getPlatformVersionOr(const String& fallback_value) const {
  if (!hasPlatformVersion()) {
  return fallback_value;
}
return member_platform_version_;
}

String UADataValues::getPlatformVersionOr(String&& fallback_value) const {
  if (!hasPlatformVersion()) {
  return std::move(fallback_value);
}
return member_platform_version_;
}

void UADataValues::setPlatformVersion(const String& value) {
  member_platform_version_ = value;
has_platform_version_ = true;
}

void UADataValues::setPlatformVersion(String&& value) {
  member_platform_version_ = std::move(value);
has_platform_version_ = true;
}




String UADataValues::getUaFullVersionOr(const String& fallback_value) const {
  if (!hasUaFullVersion()) {
  return fallback_value;
}
return member_ua_full_version_;
}

String UADataValues::getUaFullVersionOr(String&& fallback_value) const {
  if (!hasUaFullVersion()) {
  return std::move(fallback_value);
}
return member_ua_full_version_;
}

void UADataValues::setUaFullVersion(const String& value) {
  member_ua_full_version_ = value;
has_ua_full_version_ = true;
}

void UADataValues::setUaFullVersion(String&& value) {
  member_ua_full_version_ = std::move(value);
has_ua_full_version_ = true;
}










void UADataValues::Trace(Visitor* visitor) const {
  visitor->Trace(member_brands_);
visitor->Trace(member_full_version_list_);
bindings::DictionaryBase::Trace(visitor);
}

void UADataValues::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void UADataValues::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasArchitecture()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_architecture_);
DCHECK(!values[0].IsEmpty());
}
if (hasBitness()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_bitness_);
DCHECK(!values[1].IsEmpty());
}
if (hasBrands()) {
  values[2] = ToV8Traits<IDLSequence<NavigatorUABrandVersion>>::ToV8(script_state, member_brands_);
DCHECK(!values[2].IsEmpty());
}
if (hasFormFactors()) {
  values[3] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_form_factors_);
DCHECK(!values[3].IsEmpty());
}
if (hasFullVersionList()) {
  values[4] = ToV8Traits<IDLSequence<NavigatorUABrandVersion>>::ToV8(script_state, member_full_version_list_);
DCHECK(!values[4].IsEmpty());
}
if (hasMobile()) {
  values[5] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_mobile_);
DCHECK(!values[5].IsEmpty());
}
if (hasModel()) {
  values[6] = ToV8Traits<IDLString>::ToV8(script_state, member_model_);
DCHECK(!values[6].IsEmpty());
}
if (hasPlatform()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_platform_);
DCHECK(!values[7].IsEmpty());
}
if (hasPlatformVersion()) {
  values[8] = ToV8Traits<IDLString>::ToV8(script_state, member_platform_version_);
DCHECK(!values[8].IsEmpty());
}
if (hasUaFullVersion()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_ua_full_version_);
DCHECK(!values[9].IsEmpty());
}
if (hasWow64()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_wow_64_);
DCHECK(!values[10].IsEmpty());
}
}

const void* UADataValues::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> UADataValues::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void UADataValues::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "UADataValues";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("architecture");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_architecture_, member_architecture_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bitness");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_bitness_, member_bitness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("brands");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<NavigatorUABrandVersion>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_brands_, member_brands_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("formFactors");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_form_factors_, member_form_factors_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fullVersionList");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<NavigatorUABrandVersion>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_full_version_list_, member_full_version_list_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mobile");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_mobile_, member_mobile_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("model");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_model_, member_model_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("platform");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_platform_, member_platform_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("platformVersion");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_platform_version_, member_platform_version_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("uaFullVersion");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_ua_full_version_, member_ua_full_version_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("wow64");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_wow_64_, member_wow_64_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> UADataValues::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
