// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOGGLE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOGGLE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class Element;
class ExceptionState;

class CORE_EXPORT ToggleEventInit : public EventInit {
  
  public:
static ToggleEventInit* Create() {
  return MakeGarbageCollected<ToggleEventInit>();
}
static ToggleEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ToggleEventInit>(isolate);
}
static ToggleEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ToggleEventInit();
explicit  ToggleEventInit(v8::Isolate* isolate);

bool hasNewState() const {
  return true;
}
const String& newState() const {
  return member_new_state_;
}
void setNewState(const String& value);
void setNewState(String&& value);

bool hasOldState() const {
  return true;
}
const String& oldState() const {
  return member_old_state_;
}
void setOldState(const String& value);
void setOldState(String&& value);

bool hasSource() const {
  return true;
}
Element* source() const {
  return member_source_.Get();
}
void setSource(Element* value) {
  member_source_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_new_state_{""};
String member_old_state_{""};
Member<Element> member_source_{nullptr};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOGGLE_EVENT_INIT_H_
