// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_text_format_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"rangeEnd",
"rangeStart",
"underlineStyle",
"underlineThickness",
};


}  // namespace 

TextFormatInit* TextFormatInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  TextFormatInit* dictionary = MakeGarbageCollected<TextFormatInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "TextFormatInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 TextFormatInit::TextFormatInit() {
  
}

 TextFormatInit::TextFormatInit(v8::Isolate* isolate) {
  
}

















String TextFormatInit::getUnderlineStyleOr(const String& fallback_value) const {
  if (!hasUnderlineStyle()) {
  return fallback_value;
}
return member_underline_style_;
}

String TextFormatInit::getUnderlineStyleOr(String&& fallback_value) const {
  if (!hasUnderlineStyle()) {
  return std::move(fallback_value);
}
return member_underline_style_;
}

void TextFormatInit::setUnderlineStyle(const String& value) {
  member_underline_style_ = value;
has_underline_style_ = true;
}

void TextFormatInit::setUnderlineStyle(String&& value) {
  member_underline_style_ = std::move(value);
has_underline_style_ = true;
}




String TextFormatInit::getUnderlineThicknessOr(const String& fallback_value) const {
  if (!hasUnderlineThickness()) {
  return fallback_value;
}
return member_underline_thickness_;
}

String TextFormatInit::getUnderlineThicknessOr(String&& fallback_value) const {
  if (!hasUnderlineThickness()) {
  return std::move(fallback_value);
}
return member_underline_thickness_;
}

void TextFormatInit::setUnderlineThickness(const String& value) {
  member_underline_thickness_ = value;
has_underline_thickness_ = true;
}

void TextFormatInit::setUnderlineThickness(String&& value) {
  member_underline_thickness_ = std::move(value);
has_underline_thickness_ = true;
}



void TextFormatInit::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void TextFormatInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "TextFormatInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("rangeEnd");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_range_end_, member_range_end_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rangeStart");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_range_start_, member_range_start_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("underlineStyle");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_underline_style_, member_underline_style_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("underlineThickness");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_underline_thickness_, member_underline_thickness_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> TextFormatInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
