// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_test_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8TestCallback::GetHumanReadableName() const {
  return "V8TestCallback";
}

v8::Maybe<String> V8TestCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const String& arg1_message_1, const String& arg2_message_2) {
  const char* const class_like_name = "TestCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<String>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<String>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<String>();
}
return helper.Result<IDLString, String>();
}
v8::Local<v8::Value> argv_arr[2];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_message_1;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_message_1 = ToV8Traits<IDLString>::ToV8(script_state, arg1_message_1);
argv[0] = v8_arg1_message_1;
v8::Local<v8::Value> v8_arg2_message_2;
v8_arg2_message_2 = ToV8Traits<IDLString>::ToV8(script_state, arg2_message_2);
argv[1] = v8_arg2_message_2;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<String>();
}
return helper.Result<IDLString, String>();
}

v8::Maybe<String> V8TestCallback::Construct(const String& arg1_message_1, const String& arg2_message_2) {
  const char* const class_like_name = "TestCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<String>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<String>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<String>();
}
return helper.Result<IDLString, String>();
}
v8::Local<v8::Value> argv_arr[2];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_message_1;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_message_1 = ToV8Traits<IDLString>::ToV8(script_state, arg1_message_1);
argv[0] = v8_arg1_message_1;
v8::Local<v8::Value> v8_arg2_message_2;
v8_arg2_message_2 = ToV8Traits<IDLString>::ToV8(script_state, arg2_message_2);
argv[1] = v8_arg2_message_2;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<String>();
}
return helper.Result<IDLString, String>();
}




}  // namespace blink
