// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TASK_SIGNAL_ANY_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TASK_SIGNAL_ANY_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_priority.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMTaskSignal;
class ExceptionState;
class V8UnionTaskPriorityOrTaskSignal;

class CORE_EXPORT TaskSignalAnyInit : public bindings::InputDictionaryBase {
  
  public:
static TaskSignalAnyInit* Create() {
  return MakeGarbageCollected<TaskSignalAnyInit>();
}
static TaskSignalAnyInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TaskSignalAnyInit>(isolate);
}
static TaskSignalAnyInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TaskSignalAnyInit();
explicit  TaskSignalAnyInit(v8::Isolate* isolate);

bool hasPriority() const {
  return true;
}
V8UnionTaskPriorityOrTaskSignal* priority() const {
  return member_priority_.Get();
}
void setPriority(V8UnionTaskPriorityOrTaskSignal* value) {
  member_priority_ = value;
DCHECK(member_priority_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionTaskPriorityOrTaskSignal> member_priority_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TASK_SIGNAL_ANY_INIT_H_
