// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SANITIZER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SANITIZER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class SanitizerAttributeNamespace;
class SanitizerElementNamespace;
class SanitizerElementNamespaceWithAttributes;
class V8UnionSanitizerAttributeNamespaceOrString;
class V8UnionSanitizerElementNamespaceOrString;
class V8UnionSanitizerElementNamespaceWithAttributesOrString;

class CORE_EXPORT SanitizerConfig : public bindings::DictionaryBase {
  
  public:
static SanitizerConfig* Create() {
  return MakeGarbageCollected<SanitizerConfig>();
}
static SanitizerConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SanitizerConfig>(isolate);
}
static SanitizerConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SanitizerConfig();
explicit  SanitizerConfig(v8::Isolate* isolate);

bool hasAttributes() const {
  return has_attributes_;
}
const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& attributes() const {
  DCHECK(hasAttributes());
return member_attributes_;
}
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const;
void setAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value);
void setAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value);

bool hasComments() const {
  return has_comments_;
}
bool comments() const {
  DCHECK(hasComments());
return member_comments_;
}
bool getCommentsOr(bool fallback_value) const {
  if (!hasComments()) {
  return fallback_value;
}
return member_comments_;
}
void setComments(bool value) {
  member_comments_ = value;
has_comments_ = true;
}

bool hasDataAttributes() const {
  return has_data_attributes_;
}
bool dataAttributes() const {
  DCHECK(hasDataAttributes());
return member_data_attributes_;
}
bool getDataAttributesOr(bool fallback_value) const {
  if (!hasDataAttributes()) {
  return fallback_value;
}
return member_data_attributes_;
}
void setDataAttributes(bool value) {
  member_data_attributes_ = value;
has_data_attributes_ = true;
}

bool hasElements() const {
  return has_elements_;
}
const HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>& elements() const {
  DCHECK(hasElements());
return member_elements_;
}
HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>> getElementsOr(const HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>> getElementsOr(HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>&& fallback_value) const;
void setElements(const HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>& value);
void setElements(HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>>&& value);

bool hasRemoveAttributes() const {
  return has_remove_attributes_;
}
const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& removeAttributes() const {
  DCHECK(hasRemoveAttributes());
return member_remove_attributes_;
}
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getRemoveAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getRemoveAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const;
void setRemoveAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value);
void setRemoveAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value);

bool hasRemoveElements() const {
  return has_remove_elements_;
}
const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& removeElements() const {
  DCHECK(hasRemoveElements());
return member_remove_elements_;
}
HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> getRemoveElementsOr(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> getRemoveElementsOr(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& fallback_value) const;
void setRemoveElements(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& value);
void setRemoveElements(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& value);

bool hasReplaceWithChildrenElements() const {
  return has_replace_with_children_elements_;
}
const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& replaceWithChildrenElements() const {
  DCHECK(hasReplaceWithChildrenElements());
return member_replace_with_children_elements_;
}
HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> getReplaceWithChildrenElementsOr(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> getReplaceWithChildrenElementsOr(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& fallback_value) const;
void setReplaceWithChildrenElements(const HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>& value);
void setReplaceWithChildrenElements(HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_attributes_ = false;
bool has_comments_ = false;
bool has_data_attributes_ = false;
bool has_elements_ = false;
bool has_remove_attributes_ = false;
bool has_remove_elements_ = false;
bool has_replace_with_children_elements_ = false;

HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> member_attributes_;
bool member_comments_;
bool member_data_attributes_;
HeapVector<Member<V8UnionSanitizerElementNamespaceWithAttributesOrString>> member_elements_;
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> member_remove_attributes_;
HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> member_remove_elements_;
HeapVector<Member<V8UnionSanitizerElementNamespaceOrString>> member_replace_with_children_elements_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SANITIZER_CONFIG_H_
