// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RETRY_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RETRY_OPTIONS_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT RetryOptions : public bindings::DictionaryBase {
  
  public:
static RetryOptions* Create() {
  return MakeGarbageCollected<RetryOptions>();
}
static RetryOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RetryOptions>(isolate);
}
static RetryOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RetryOptions();
explicit  RetryOptions(v8::Isolate* isolate);

bool hasBackoffFactor() const {
  return has_backoff_factor_;
}
const std::optional<double>& backoffFactor() const {
  DCHECK(hasBackoffFactor());
return member_backoff_factor_;
}
std::optional<double> getBackoffFactorOr(const std::optional<double>& fallback_value) const {
  if (!hasBackoffFactor()) {
  return fallback_value;
}
return member_backoff_factor_;
}
void setBackoffFactor(const std::optional<double>& value) {
  member_backoff_factor_ = value;
has_backoff_factor_ = true;
}
void setBackoffFactor(double value) {
  member_backoff_factor_ = value;
has_backoff_factor_ = true;
}

bool hasInitialDelay() const {
  return has_initial_delay_;
}
const std::optional<uint32_t>& initialDelay() const {
  DCHECK(hasInitialDelay());
return member_initial_delay_;
}
std::optional<uint32_t> getInitialDelayOr(const std::optional<uint32_t>& fallback_value) const {
  if (!hasInitialDelay()) {
  return fallback_value;
}
return member_initial_delay_;
}
void setInitialDelay(const std::optional<uint32_t>& value) {
  member_initial_delay_ = value;
has_initial_delay_ = true;
}
void setInitialDelay(uint32_t value) {
  member_initial_delay_ = value;
has_initial_delay_ = true;
}

bool hasMaxAge() const {
  return true;
}
uint32_t maxAge() const {
  return member_max_age_;
}
void setMaxAge(uint32_t value) {
  member_max_age_ = value;
}

bool hasMaxAttempts() const {
  return true;
}
uint32_t maxAttempts() const {
  return member_max_attempts_;
}
void setMaxAttempts(uint32_t value) {
  member_max_attempts_ = value;
}

bool hasRetryAfterUnload() const {
  return true;
}
bool retryAfterUnload() const {
  return member_retry_after_unload_;
}
void setRetryAfterUnload(bool value) {
  member_retry_after_unload_ = value;
}

bool hasRetryNonIdempotent() const {
  return true;
}
bool retryNonIdempotent() const {
  return member_retry_non_idempotent_;
}
void setRetryNonIdempotent(bool value) {
  member_retry_non_idempotent_ = value;
}

bool hasRetryOnlyIfServerUnreached() const {
  return true;
}
bool retryOnlyIfServerUnreached() const {
  return member_retry_only_if_server_unreached_;
}
void setRetryOnlyIfServerUnreached(bool value) {
  member_retry_only_if_server_unreached_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_backoff_factor_ = false;
bool has_initial_delay_ = false;

std::optional<double> member_backoff_factor_;
std::optional<uint32_t> member_initial_delay_;
uint32_t member_max_age_;
uint32_t member_max_attempts_;
bool member_retry_after_unload_{false};
bool member_retry_non_idempotent_{false};
bool member_retry_only_if_server_unreached_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RETRY_OPTIONS_H_
