// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_request_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_attribution_reporting_request_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_private_token.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_retry_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_bytestringbytestringrecord_bytestringsequencesequence.h"
#include "third_party/blink/renderer/core/dom/abort_signal.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"adAuctionHeaders",
"attributionReporting",
"body",
"browsingTopics",
"cache",
"credentials",
"duplex",
"headers",
"integrity",
"keepalive",
"method",
"mode",
"priority",
"privateToken",
"redirect",
"referrer",
"referrerPolicy",
"retryOptions",
"sharedStorageWritable",
"signal",
"targetAddressSpace",
};


}  // namespace 

RequestInit* RequestInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RequestInit* dictionary = MakeGarbageCollected<RequestInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RequestInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RequestInit::RequestInit() {
  
}

 RequestInit::RequestInit(v8::Isolate* isolate) {
  
}



























































String RequestInit::getIntegrityOr(const String& fallback_value) const {
  if (!hasIntegrity()) {
  return fallback_value;
}
return member_integrity_;
}

String RequestInit::getIntegrityOr(String&& fallback_value) const {
  if (!hasIntegrity()) {
  return std::move(fallback_value);
}
return member_integrity_;
}

void RequestInit::setIntegrity(const String& value) {
  member_integrity_ = value;
has_integrity_ = true;
}

void RequestInit::setIntegrity(String&& value) {
  member_integrity_ = std::move(value);
has_integrity_ = true;
}











String RequestInit::getMethodOr(const String& fallback_value) const {
  if (!hasMethod()) {
  return fallback_value;
}
return member_method_;
}

String RequestInit::getMethodOr(String&& fallback_value) const {
  if (!hasMethod()) {
  return std::move(fallback_value);
}
return member_method_;
}

void RequestInit::setMethod(const String& value) {
  member_method_ = value;
has_method_ = true;
}

void RequestInit::setMethod(String&& value) {
  member_method_ = std::move(value);
has_method_ = true;
}
































String RequestInit::getReferrerOr(const String& fallback_value) const {
  if (!hasReferrer()) {
  return fallback_value;
}
return member_referrer_;
}

String RequestInit::getReferrerOr(String&& fallback_value) const {
  if (!hasReferrer()) {
  return std::move(fallback_value);
}
return member_referrer_;
}

void RequestInit::setReferrer(const String& value) {
  member_referrer_ = value;
has_referrer_ = true;
}

void RequestInit::setReferrer(String&& value) {
  member_referrer_ = std::move(value);
has_referrer_ = true;
}






































void RequestInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_attribution_reporting_);
visitor->Trace(member_body_);
visitor->Trace(member_headers_);
visitor->Trace(member_private_token_);
visitor->Trace(member_retry_options_);
visitor->Trace(member_signal_);
bindings::InputDictionaryBase::Trace(visitor);
}

void RequestInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
const char* const class_like_name = "RequestInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (execution_context->IsWindow() && RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("adAuctionHeaders");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_ad_auction_headers_, member_ad_auction_headers_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::AttributionReportingEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("attributionReporting");
if (!bindings::GetDictionaryMemberFromV8Object<AttributionReportingRequestOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_attribution_reporting_, member_attribution_reporting_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("body");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_body_, class_like_name, exception_state)) {
  return;
}
if (execution_context->IsWindow() && RuntimeEnabledFeatures::TopicsAPIEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("browsingTopics");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_browsing_topics_, member_browsing_topics_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("cache");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestCache, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_cache_, member_cache_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credentials");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestCredentials, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_credentials_, member_credentials_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FetchUploadStreamingEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("duplex");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestDuplex, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_duplex_, member_duplex_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("headers");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionByteStringByteStringRecordOrByteStringSequenceSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_headers_, member_headers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("integrity");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_integrity_, member_integrity_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keepalive");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_keepalive_, member_keepalive_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("method");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByteString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_method_, member_method_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mode");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_mode_, member_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("priority");
if (!bindings::GetDictionaryMemberFromV8Object<V8FetchPriority, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_priority_, member_priority_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::PrivateStateTokensEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("privateToken");
if (!bindings::GetDictionaryMemberFromV8Object<PrivateToken, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_private_token_, member_private_token_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("redirect");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestRedirect, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_redirect_, member_redirect_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("referrer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_referrer_, member_referrer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("referrerPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<V8ReferrerPolicy, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_referrer_policy_, member_referrer_policy_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FetchRetryEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("retryOptions");
if (!bindings::GetDictionaryMemberFromV8Object<RetryOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_retry_options_, member_retry_options_, class_like_name, exception_state)) {
  return;
}
}
if (execution_context->IsWindow() && RuntimeEnabledFeatures::SharedStorageAPIEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("sharedStorageWritable");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_shared_storage_writable_, member_shared_storage_writable_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<AbortSignal>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_signal_, member_signal_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::LocalNetworkAccessPermissionPolicyEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("targetAddressSpace");
if (!bindings::GetDictionaryMemberFromV8Object<V8IPAddressSpace, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_target_address_space_, member_target_address_space_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> RequestInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
