// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROMISE_REJECTION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROMISE_REJECTION_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_promise.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PromiseRejectionEventInit : public EventInit {
  
  public:
static PromiseRejectionEventInit* Create() {
  return MakeGarbageCollected<PromiseRejectionEventInit>();
}
static PromiseRejectionEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PromiseRejectionEventInit>(isolate);
}
static PromiseRejectionEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PromiseRejectionEventInit();
explicit  PromiseRejectionEventInit(v8::Isolate* isolate);

bool hasPromise() const {
  return true;
}
const MemberScriptPromise<IDLAny>& promise() const {
  return member_promise_;
}
void setPromise(const MemberScriptPromise<IDLAny>& value) {
  member_promise_ = value;
}

bool hasReason() const {
  return !member_reason_.IsEmpty();
}
const ScriptValue& reason() const {
  DCHECK(hasReason());
return member_reason_;
}
ScriptValue getReasonOr(const ScriptValue& fallback_value) const {
  if (!hasReason()) {
  return fallback_value;
}
return member_reason_;
}
void setReason(const ScriptValue& value) {
  member_reason_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



MemberScriptPromise<IDLAny> member_promise_;
ScriptValue member_reason_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROMISE_REJECTION_EVENT_INIT_H_
