// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_TRACE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_TRACE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ProfilerFrame;
class ProfilerSample;
class ProfilerStack;

class CORE_EXPORT ProfilerTrace : public bindings::DictionaryBase {
  
  public:
static ProfilerTrace* Create() {
  return MakeGarbageCollected<ProfilerTrace>();
}
static ProfilerTrace* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProfilerTrace>(isolate);
}
static ProfilerTrace* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProfilerTrace();
explicit  ProfilerTrace(v8::Isolate* isolate);

bool hasFrames() const {
  return true;
}
const HeapVector<Member<ProfilerFrame>>& frames() const {
  return member_frames_;
}
void setFrames(const HeapVector<Member<ProfilerFrame>>& value);
void setFrames(HeapVector<Member<ProfilerFrame>>&& value);

bool hasResources() const {
  return true;
}
const Vector<String>& resources() const {
  return member_resources_;
}
void setResources(const Vector<String>& value);
void setResources(Vector<String>&& value);

bool hasSamples() const {
  return true;
}
const HeapVector<Member<ProfilerSample>>& samples() const {
  return member_samples_;
}
void setSamples(const HeapVector<Member<ProfilerSample>>& value);
void setSamples(HeapVector<Member<ProfilerSample>>&& value);

bool hasStacks() const {
  return true;
}
const HeapVector<Member<ProfilerStack>>& stacks() const {
  return member_stacks_;
}
void setStacks(const HeapVector<Member<ProfilerStack>>& value);
void setStacks(HeapVector<Member<ProfilerStack>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<ProfilerFrame>> member_frames_;
Vector<String> member_resources_;
HeapVector<Member<ProfilerSample>> member_samples_;
HeapVector<Member<ProfilerStack>> member_stacks_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_TRACE_H_
