// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_STACK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_STACK_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ProfilerStack : public bindings::DictionaryBase {
  
  public:
static ProfilerStack* Create() {
  return MakeGarbageCollected<ProfilerStack>();
}
static ProfilerStack* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProfilerStack>(isolate);
}
static ProfilerStack* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProfilerStack();
explicit  ProfilerStack(v8::Isolate* isolate);

bool hasFrameId() const {
  return true;
}
uint64_t frameId() const {
  return member_frame_id_;
}
void setFrameId(uint64_t value) {
  member_frame_id_ = value;
}

bool hasParentId() const {
  return has_parent_id_;
}
uint64_t parentId() const {
  DCHECK(hasParentId());
return member_parent_id_;
}
uint64_t getParentIdOr(uint64_t fallback_value) const {
  if (!hasParentId()) {
  return fallback_value;
}
return member_parent_id_;
}
void setParentId(uint64_t value) {
  member_parent_id_ = value;
has_parent_id_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_parent_id_ = false;

uint64_t member_frame_id_;
uint64_t member_parent_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_STACK_H_
