// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_profiler_sample.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"marker",
"stackId",
"timestamp",
};


}  // namespace 

ProfilerSample* ProfilerSample::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ProfilerSample* dictionary = MakeGarbageCollected<ProfilerSample>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ProfilerSample";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ProfilerSample::ProfilerSample() {
  
}

 ProfilerSample::ProfilerSample(v8::Isolate* isolate) {
  
}





















void ProfilerSample::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void ProfilerSample::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ProfilerSample::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
const bool is_cross_origin_isolated = execution_context->CrossOriginIsolatedCapabilityOrDisabledWebSecurity();
if (is_cross_origin_isolated && RuntimeEnabledFeatures::ExperimentalJSProfilerMarkersEnabled()) {
  if (hasMarker()) {
  values[0] = ToV8Traits<V8ProfilerMarker>::ToV8(script_state, member_marker_);
DCHECK(!values[0].IsEmpty());
}
}
if (hasStackId()) {
  values[1] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_stack_id_);
DCHECK(!values[1].IsEmpty());
}
if (hasTimestamp()) {
  values[2] = ToV8Traits<IDLDouble>::ToV8(script_state, member_timestamp_);
DCHECK(!values[2].IsEmpty());
}
}

const void* ProfilerSample::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ProfilerSample::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ProfilerSample::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
const bool is_cross_origin_isolated = execution_context->CrossOriginIsolatedCapabilityOrDisabledWebSecurity();
const char* const class_like_name = "ProfilerSample";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (is_cross_origin_isolated && RuntimeEnabledFeatures::ExperimentalJSProfilerMarkersEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("marker");
if (!bindings::GetDictionaryMemberFromV8Object<V8ProfilerMarker, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_marker_, member_marker_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("stackId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_stack_id_, member_stack_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timestamp");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_timestamp_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ProfilerSample::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
