// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_INIT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_INIT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ProfilerInitOptions : public bindings::InputDictionaryBase {
  
  public:
static ProfilerInitOptions* Create() {
  return MakeGarbageCollected<ProfilerInitOptions>();
}
static ProfilerInitOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProfilerInitOptions>(isolate);
}
static ProfilerInitOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProfilerInitOptions();
explicit  ProfilerInitOptions(v8::Isolate* isolate);

bool hasMaxBufferSize() const {
  return true;
}
uint32_t maxBufferSize() const {
  return member_max_buffer_size_;
}
void setMaxBufferSize(uint32_t value) {
  member_max_buffer_size_ = value;
}

bool hasSampleInterval() const {
  return true;
}
double sampleInterval() const {
  return member_sample_interval_;
}
void setSampleInterval(double value) {
  member_sample_interval_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_max_buffer_size_;
double member_sample_interval_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_INIT_OPTIONS_H_
