// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PRIVATE_TOKEN_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PRIVATE_TOKEN_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_operation_type.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_private_token_version.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_refresh_policy.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PrivateToken : public bindings::InputDictionaryBase {
  
  public:
static PrivateToken* Create() {
  return MakeGarbageCollected<PrivateToken>();
}
static PrivateToken* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PrivateToken>(isolate);
}
static PrivateToken* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PrivateToken();
explicit  PrivateToken(v8::Isolate* isolate);

bool hasIssuers() const {
  return has_issuers_;
}
const Vector<String>& issuers() const {
  DCHECK(hasIssuers());
return member_issuers_;
}
Vector<String> getIssuersOr(const Vector<String>& fallback_value) const;
Vector<String> getIssuersOr(Vector<String>&& fallback_value) const;
void setIssuers(const Vector<String>& value);
void setIssuers(Vector<String>&& value);

bool hasOperation() const {
  return true;
}
V8OperationType operation() const {
  return member_operation_;
}
void setOperation(V8OperationType value) {
  member_operation_ = value;
}
void setOperation(V8OperationType::Enum value) {
  member_operation_ = V8OperationType(value);
}

bool hasRefreshPolicy() const {
  return true;
}
V8RefreshPolicy refreshPolicy() const {
  return member_refresh_policy_;
}
void setRefreshPolicy(V8RefreshPolicy value) {
  member_refresh_policy_ = value;
}
void setRefreshPolicy(V8RefreshPolicy::Enum value) {
  member_refresh_policy_ = V8RefreshPolicy(value);
}

bool hasVersion() const {
  return true;
}
V8PrivateTokenVersion version() const {
  return member_version_;
}
void setVersion(V8PrivateTokenVersion value) {
  member_version_ = value;
}
void setVersion(V8PrivateTokenVersion::Enum value) {
  member_version_ = V8PrivateTokenVersion(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_issuers_ = false;

Vector<String> member_issuers_;
V8OperationType member_operation_{static_cast<V8OperationType::Enum>(0)};
V8RefreshPolicy member_refresh_policy_{V8RefreshPolicy::Enum::kNone};
V8PrivateTokenVersion member_version_{static_cast<V8PrivateTokenVersion::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PRIVATE_TOKEN_H_
