// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POSITION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POSITION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PositionOptions : public bindings::InputDictionaryBase {
  
  public:
static PositionOptions* Create() {
  return MakeGarbageCollected<PositionOptions>();
}
static PositionOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PositionOptions>(isolate);
}
static PositionOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PositionOptions();
explicit  PositionOptions(v8::Isolate* isolate);

bool hasEnableHighAccuracy() const {
  return true;
}
bool enableHighAccuracy() const {
  return member_enable_high_accuracy_;
}
void setEnableHighAccuracy(bool value) {
  member_enable_high_accuracy_ = value;
}

bool hasMaximumAge() const {
  return true;
}
uint32_t maximumAge() const {
  return member_maximum_age_;
}
void setMaximumAge(uint32_t value) {
  member_maximum_age_ = value;
}

bool hasTimeout() const {
  return true;
}
uint32_t timeout() const {
  return member_timeout_;
}
void setTimeout(uint32_t value) {
  member_timeout_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_enable_high_accuracy_{false};
uint32_t member_maximum_age_{0};
uint32_t member_timeout_{0xFFFFFFFF};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POSITION_OPTIONS_H_
