// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_performance_observer_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"buffered",
"durationThreshold",
"entryTypes",
"type",
};


}  // namespace 

PerformanceObserverInit* PerformanceObserverInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PerformanceObserverInit* dictionary = MakeGarbageCollected<PerformanceObserverInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PerformanceObserverInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PerformanceObserverInit::PerformanceObserverInit() {
  
}

 PerformanceObserverInit::PerformanceObserverInit(v8::Isolate* isolate) {
  
}















Vector<String> PerformanceObserverInit::getEntryTypesOr(const Vector<String>& fallback_value) const {
  if (!hasEntryTypes()) {
  return fallback_value;
}
return member_entry_types_;
}

Vector<String> PerformanceObserverInit::getEntryTypesOr(Vector<String>&& fallback_value) const {
  if (!hasEntryTypes()) {
  return std::move(fallback_value);
}
return member_entry_types_;
}

void PerformanceObserverInit::setEntryTypes(const Vector<String>& value) {
  member_entry_types_ = value;
has_entry_types_ = true;
}

void PerformanceObserverInit::setEntryTypes(Vector<String>&& value) {
  member_entry_types_ = std::move(value);
has_entry_types_ = true;
}




String PerformanceObserverInit::getTypeOr(const String& fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}

String PerformanceObserverInit::getTypeOr(String&& fallback_value) const {
  if (!hasType()) {
  return std::move(fallback_value);
}
return member_type_;
}

void PerformanceObserverInit::setType(const String& value) {
  member_type_ = value;
has_type_ = true;
}

void PerformanceObserverInit::setType(String&& value) {
  member_type_ = std::move(value);
has_type_ = true;
}



void PerformanceObserverInit::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void PerformanceObserverInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PerformanceObserverInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("buffered");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_buffered_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("durationThreshold");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_duration_threshold_, member_duration_threshold_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("entryTypes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_entry_types_, member_entry_types_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PerformanceObserverInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
