// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MESSAGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MESSAGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class EventTarget;
class ExceptionState;
class MessagePort;
class UserActivation;

class CORE_EXPORT MessageEventInit : public EventInit {
  
  public:
static MessageEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MessageEventInit>(isolate);
}
static MessageEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MessageEventInit(v8::Isolate* isolate);

bool hasData() const {
  return true;
}
const ScriptValue& data() const {
  return member_data_;
}
void setData(const ScriptValue& value) {
  member_data_ = value;
}

bool hasLastEventId() const {
  return true;
}
const String& lastEventId() const {
  return member_last_event_id_;
}
void setLastEventId(const String& value);
void setLastEventId(String&& value);

bool hasOrigin() const {
  return true;
}
const String& origin() const {
  return member_origin_;
}
void setOrigin(const String& value);
void setOrigin(String&& value);

bool hasPorts() const {
  return true;
}
const HeapVector<Member<MessagePort>>& ports() const {
  return member_ports_;
}
void setPorts(const HeapVector<Member<MessagePort>>& value);
void setPorts(HeapVector<Member<MessagePort>>&& value);

bool hasSource() const {
  return true;
}
EventTarget* source() const {
  return member_source_.Get();
}
void setSource(EventTarget* value) {
  member_source_ = value;
}

bool hasUserActivation() const {
  return true;
}
UserActivation* userActivation() const {
  return member_user_activation_.Get();
}
void setUserActivation(UserActivation* value) {
  member_user_activation_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



ScriptValue member_data_;
String member_last_event_id_{""};
String member_origin_{""};
HeapVector<Member<MessagePort>> member_ports_;
Member<EventTarget> member_source_{nullptr};
Member<UserActivation> member_user_activation_{nullptr};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MESSAGE_EVENT_INIT_H_
